<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-14 13:25:42
 */
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class CouponV2
 * @method bulkGenerateCouponsByParams(array $params) 批量生成券码
 * @method templateStatisticByParams(array $params) 统计模板数量
 * @method getCouponsByParams(array $params) 券码列表-分页
 * @method rechargeByParams(array $params) 充值
 * @method bulkGenerateMultiTemplateCouponsByParams(array $params) 批量生成不同模板券码
 */
class CouponV2 {
    private static string $serviceName = "Preferential";

    private static string $className = "CouponV2";

    /**
     * 批量生成券码
     * @return  int
    */
    public static function bulkGenerateCoupons (\Mainto\Bridge\Structs\Preferential\Coupon\Cmd\CouponCreateCmd $couponCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkGenerateCoupons($couponCreateCmd);
    }

    /**
     * 统计模板数量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function templateStatistic (array $templateIds) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->templateStatistic(["templateIds" => $templateIds]),
            "\Mainto\Bridge\Structs\Preferential\Coupon\DTO\TemplateStatisticDTO[]"
        );
    }

    /**
     * 券码列表-分页
     * @return  \Mainto\Bridge\Structs\Preferential\Coupon\DTO\CouponListDTO
    */
    public static function getCoupons (?\Mainto\Bridge\Structs\Preferential\Coupon\Cmd\CouponListForPageCmd $couponListForPageCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCoupons($couponListForPageCmd),
            "\Mainto\Bridge\Structs\Preferential\Coupon\DTO\CouponListDTO"
        );
    }

    /**
     * 充值
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function recharge (int $userId, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->recharge(["userId" => $userId, "code" => $code]);
    }

    /**
     * 批量生成不同模板券码
     * @return  array
    */
    public static function bulkGenerateMultiTemplateCoupons (\Mainto\Bridge\Structs\Preferential\Coupon\Cmd\MultiTemplateCouponCreateCmd $multiTemplateCouponCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkGenerateMultiTemplateCoupons($multiTemplateCouponCreateCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}