<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-14 10:38:28
 */
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductCardOrder
 * @method createByParams(array $params) 创建产品卡订单包含支付，接口已作废，请使用createVirtualCardOrder，createPhysicalCardOrder
 * @method prepaidCreateByParams(array $params) 创建产品卡订单【线上】
 * @method afterPayByParams(array $params) 产品卡订单支付
 * @method getOrdersByParams(array $params) 获取列表
 * @method getInfoByParams(array $params) 获取详情
 * @method getOrderByOrderNumByParams(array $params) 通过订单号获取订单
 * @method getOrderByOrderNumWithItemByParams(array $params) 通过订单号获取订单
 * @method updateInvoiceIdByParams(array $params) updateInvoiceId
 * @method changePayTypeByParams(array $params) 修改支付方式
 */
class ProductCardOrder {
    private static string $serviceName = "Preferential";

    private static string $className = "Coupon\\ProductCardOrder";

    /**
     * 创建产品卡订单包含支付，接口已作废，请使用createVirtualCardOrder，createPhysicalCardOrder
     * @return  int
    */
    public static function create (string $phone, int $user_id, int $create_by, string $user_name, float $ori_money, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["phone" => $phone, "user_id" => $user_id, "create_by" => $create_by, "user_name" => $user_name, "ori_money" => $ori_money, "extend" => $extend]);
    }
    /**
     * 创建产品卡订单【线上】
     * @return  int
    */
    public static function prepaidCreate (string $phone, int $user_id, int $store_id, int $create_by, string $user_name, float $ori_money, \Mainto\Bridge\Structs\Preferential\Coupon\ProductCardOrder\PrepaidCreateParamsExtend $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->prepaidCreate(["phone" => $phone, "user_id" => $user_id, "store_id" => $store_id, "create_by" => $create_by, "user_name" => $user_name, "ori_money" => $ori_money, "extend" => $extend]);
    }
    /**
     * 产品卡订单支付
     * @return  int
    */
    public static function afterPay (int $order_id, string $pay_type, string $payment_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterPay(["order_id" => $order_id, "pay_type" => $pay_type, "payment_no" => $payment_no]);
    }
    /**
     * 获取列表
     * @return  array
    */
    public static function getOrders () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrders([]);
    }
    /**
     * 获取详情
     * @return  array
    */
    public static function getInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfo(["id" => $id]);
    }
    /**
     * 通过订单号获取订单
     * @return  array
    */
    public static function getOrderByOrderNum (string $order_num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderByOrderNum(["order_num" => $order_num]);
    }
    /**
     * 通过订单号获取订单
     * @return  array
    */
    public static function getOrderByOrderNumWithItem (string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderByOrderNumWithItem(["orderNum" => $orderNum]);
    }
    /**
     * updateInvoiceId
     * @return  bool
    */
    public static function updateInvoiceId (array $order_nums, int $invoice_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateInvoiceId(["order_nums" => $order_nums, "invoice_id" => $invoice_id]);
    }
    /**
     * 修改支付方式
     * @return  bool
    */
    public static function changePayType (int $id, string $pay_type, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "pay_type" => $pay_type, "extend" => $extend]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}