<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-12 10:06:52
 */
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Coupon
 * @method bulkGenerateCouponsByParams(array $params) 批量生成优惠券
 * @method bulkGenerateMultiUserCouponsByParams(array $params) 批量生成绑定多用户券码
 * @method listByParams(array $params) 获取列表
 * @method getCouponsByParams(array $params) 获取列表-分页
 * @method infoByParams(array $params) 获取详情
 * @method delayByParams(array $params) 优惠券延期
 * @method updateTransferInfoByParams(array $params) 更新适用订单【转门店】
 * @method getUserCouponsByParams(array $params) 获得用户优惠券
 * @method markUserCouponsByParams(array $params) 标记用户券是否可用
 * @method useByParams(array $params) 使用优惠券
 * @method getCouponDiscountPriceByParams(array $params) 获得优惠券可折扣金额
 * @method getSpecialCouponDiscountByParams(array $params) 加修加印券和加印券可折扣金额
 * @method bindByParams(array $params) 绑定优惠券
 * @method refundByParams(array $params) 退款返回优惠券
 * @method abolishCouponsByParams(array $params) 作废优惠券
 * @method statisticCouponsByParams(array $params) 渠道统计
 * @method statisticCouponsByLogIdsByParams(array $params) 创建记录统计
 */
class Coupon {
    private static string $serviceName = "Preferential";

    private static string $className = "Coupon\\Coupon";

    /**
     * 批量生成优惠券
     * @return  array
    */
    public static function bulkGenerateCoupons (string $title, int $templateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkGenerateCoupons(["title" => $title, "templateId" => $templateId]);
    }
    /**
     * 批量生成绑定多用户券码
     * @return  array
    */
    public static function bulkGenerateMultiUserCoupons (int $createBy, int $templateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkGenerateMultiUserCoupons(["createBy" => $createBy, "templateId" => $templateId]);
    }
    /**
     * 获取列表
     * @return  array
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }
    /**
     * 获取列表-分页
     * @return  array
    */
    public static function getCoupons () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCoupons([]);
    }
    /**
     * 获取详情
     * @return  array
    */
    public static function info () {
        return RpcClass::getClass(self::$serviceName, self::$className)->info([]);
    }
    /**
     * 优惠券延期
     * @return  bool
    */
    public static function delay () {
        return RpcClass::getClass(self::$serviceName, self::$className)->delay([]);
    }
    /**
     * 更新适用订单【转门店】
     * @return  bool
    */
    public static function updateTransferInfo (int $couponId, int $newOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateTransferInfo(["couponId" => $couponId, "newOrderId" => $newOrderId]);
    }
    /**
     * 获得用户优惠券
     * @return  array
    */
    public static function getUserCoupons (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserCoupons(["user_id" => $user_id]);
    }
    /**
     * 标记用户券是否可用
     * @return  array
    */
    public static function markUserCoupons (int $userId, int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->markUserCoupons(["userId" => $userId, "storeId" => $storeId]);
    }
    /**
     * 使用优惠券
     * @return  bool
    */
    public static function use (int $id, int $user_id, int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->use(["id" => $id, "user_id" => $user_id, "order_id" => $order_id]);
    }
    /**
     * 获得优惠券可折扣金额
     * @return  array
    */
    public static function getCouponDiscountPrice (int $couponId, array $nodeInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponDiscountPrice(["couponId" => $couponId, "nodeInfo" => $nodeInfo]);
    }
    /**
     * 加修加印券和加印券可折扣金额
     * @return  float
    */
    public static function getSpecialCouponDiscount (int $couponId, float $perPrice) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSpecialCouponDiscount(["couponId" => $couponId, "perPrice" => $perPrice]);
    }
    /**
     * 绑定优惠券
     * @return  bool
    */
    public static function bind (int $user_id, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bind(["user_id" => $user_id, "code" => $code]);
    }
    /**
     * 退款返回优惠券
     * @return  bool
    */
    public static function refund (int $coupon_id, int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refund(["coupon_id" => $coupon_id, "user_id" => $user_id]);
    }
    /**
     * 作废优惠券
     * @return  bool
    */
    public static function abolishCoupons () {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolishCoupons([]);
    }
    /**
     * 渠道统计
     * @return  array
    */
    public static function statisticCoupons (int $channel) {
        return RpcClass::getClass(self::$serviceName, self::$className)->statisticCoupons(["channel" => $channel]);
    }
    /**
     * 创建记录统计
     * @return  array
    */
    public static function statisticCouponsByLogIds (array $logIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->statisticCouponsByLogIds(["logIds" => $logIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}