<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-29 17:59:49
 */
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class GiftCardWithdraw
 * @method applyWithdrawByParams(array $params) 申请礼品卡提现
 * @method passWithdrawByParams(array $params) 通过申请礼品卡提现
 * @method refuseWithdrawByParams(array $params) 拒绝申请礼品卡提现
 */
class GiftCardWithdraw {
    private static string $serviceName = "Preferential";

    private static string $className = "GiftCard\\GiftCardWithdraw";

    /**
     * 申请礼品卡提现
     * @return  int
    */
    public static function applyWithdraw (int $cardId, float $money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->applyWithdraw(["cardId" => $cardId, "money" => $money]);
    }
    /**
     * 通过申请礼品卡提现
     * @return  bool
    */
    public static function passWithdraw (int $recordId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->passWithdraw(["recordId" => $recordId]);
    }
    /**
     * 拒绝申请礼品卡提现
     * @return  bool
    */
    public static function refuseWithdraw (int $recordId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refuseWithdraw(["recordId" => $recordId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}