<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bulkGenerateCouponsByParams(array|\Mainto\Bridge\Structs\Preferential\Coupon\Cmd\CouponCreateCmd $params)
 * @method templateStatisticByParams(array $params)
 * @method getCouponsByParams(array|\Mainto\Bridge\Structs\Preferential\Coupon\Cmd\CouponListForPageCmd $params)
 * @method rechargeByParams(array $params)
 * @method bulkGenerateMultiTemplateCouponsByParams(array|\Mainto\Bridge\Structs\Preferential\Coupon\Cmd\MultiTemplateCouponCreateCmd $params)
 */
class CouponV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量生成券码
     *
     * @var  \Mainto\Bridge\Structs\Preferential\Coupon\Cmd\CouponCreateCmd $cmd
     * @throws  \Exception
     * @return  int
     */
    public static function bulkGenerateCoupons (\Mainto\Bridge\Structs\Preferential\Coupon\Cmd\CouponCreateCmd $cmd) {
        return self::getClass()->bulkGenerateCoupons($cmd);
    }


    /**
     * 统计模板数量
     *
     * @param  array $templateIds 模板ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Preferential\Coupon\DTO\TemplateStatisticDTO[]
     */
    public static function templateStatistic (array $templateIds) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->templateStatistic([
                            "templateIds" => $templateIds,
                        ]),
            "\Mainto\Bridge\Structs\Preferential\Coupon\DTO\TemplateStatisticDTO[]"
        );
    }

    /**
     * 券码列表-分页
     *
     * @var  \Mainto\Bridge\Structs\Preferential\Coupon\Cmd\CouponListForPageCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Preferential\Coupon\DTO\CouponListDTO
     */
    public static function getCoupons (\Mainto\Bridge\Structs\Preferential\Coupon\Cmd\CouponListForPageCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCoupons($cmd),
            "\Mainto\Bridge\Structs\Preferential\Coupon\DTO\CouponListDTO"
        );
    }


    /**
     * 充值
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $code 兑换码 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function recharge (int $userId, string $code) {
        return self::getClass()->recharge([
            "userId" => $userId,
            "code" => $code,
        ]);
    }

    /**
     * 批量生成不同模板券码
     *
     * @var  \Mainto\Bridge\Structs\Preferential\Coupon\Cmd\MultiTemplateCouponCreateCmd $createCmd
     * @throws  \Exception
     * @return  array
     */
    public static function bulkGenerateMultiTemplateCoupons (\Mainto\Bridge\Structs\Preferential\Coupon\Cmd\MultiTemplateCouponCreateCmd $createCmd) {
        return self::getClass()->bulkGenerateMultiTemplateCoupons($createCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'CouponV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'CouponV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}