<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method preferentialCompleteByParams(array $params)
 * @method preferentialRefundByParams(array $params)
 * @method convertUserInfoByParams(array $params)
 * @method giftCardOrderFinishedByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单完成-会员处理
     *
     * @support  string $source 订单来源 [ require true ]
     * @support  int $userId 用户ID [ require true ]
     * @support  int $orderId 订单ID [ require true ]
     * @support  array $couponInfo 优惠券信息 [ require false ]
     * @support  array $productCardInfo 产品卡信息 [ require false ]
     * @throws  \Exception
     * @return  void
     */
    public static function preferentialComplete () {
        return self::getClass()->preferentialComplete([
        ]);
    }

    /**
     * 订单退款-会员流水
     *
     * @support  string $source 订单来源 [ require true ]
     * @support  int $userId 用户ID [ require true ]
     * @support  int $orderId 订单ID [ require true ]
     * @support  array $couponInfo 优惠券信息 [ require false ]
     * @support  array $productCardInfo 产品卡信息 [ require false ]
     * @throws  \Exception
     * @return  void
     */
    public static function preferentialRefund () {
        return self::getClass()->preferentialRefund([
        ]);
    }

    /**
     * 更新券用户信息
     *
     * @support  int $user_id 用户ID [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function convertUserInfo () {
        return self::getClass()->convertUserInfo([
        ]);
    }

    /**
     * 礼品卡订单创建事件
     *
     * @param  int $orderId 订单Id [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function giftCardOrderFinished (int $orderId) {
        return self::getClass()->giftCardOrderFinished([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Message');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}