<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-23 11:22:15
 */
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Stock
 * @method allocateByParams(array $params) 调配
 * @method getStocksByParams(array $params) 库存查询-分页
 * @method getStockProductsByParams(array $params) 获取库存记录列表-分页
 * @method listForStockProductsByParams(array $params) 获取库存记录列表-不分页
 * @method getStockProductsWithTrashedByParams(array $params) 获取库存记录列表-不分页
 * @method infoByParams(array $params) 获取库存记录详情
 * @method getStockProductByParams(array $params) 获取库存详情信息
 * @method stockLockByParams(array $params) 锁定库存
 * @method releaseStockLockByParams(array $params) 释放锁定库存
 */
class Stock {
    private static string $serviceName = "Preferential";

    private static string $className = "Stock";

    /**
     * 调配
     * @return  bool
    */
    public static function allocate (int $operator, int $stockStoreId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->allocate(["operator" => $operator, "stockStoreId" => $stockStoreId]);
    }
    /**
     * 库存查询-分页
     * @return  array
    */
    public static function getStocks () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStocks([]);
    }
    /**
     * 获取库存记录列表-分页
     * @return  array
    */
    public static function getStockProducts () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockProducts([]);
    }
    /**
     * 获取库存记录列表-不分页
     * @return  array
    */
    public static function listForStockProducts () {
        return RpcClass::getClass(self::$serviceName, self::$className)->listForStockProducts([]);
    }
    /**
     * 获取库存记录列表-不分页
     * @return  array
    */
    public static function getStockProductsWithTrashed (array $cardIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockProductsWithTrashed(["cardIds" => $cardIds]);
    }
    /**
     * 获取库存记录详情
     * @return  array
    */
    public static function info () {
        return RpcClass::getClass(self::$serviceName, self::$className)->info([]);
    }
    /**
     * 获取库存详情信息
     * @return  array
    */
    public static function getStockProduct () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockProduct([]);
    }
    /**
     * 锁定库存
     * @return  bool
    */
    public static function stockLock (int $storeId, array $cardIds, int $operator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stockLock(["storeId" => $storeId, "cardIds" => $cardIds, "operator" => $operator]);
    }
    /**
     * 释放锁定库存
     * @return  bool
    */
    public static function releaseStockLock (int $storeId, array $cardIds, int $operator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->releaseStockLock(["storeId" => $storeId, "cardIds" => $cardIds, "operator" => $operator]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}