<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-24 14:42:36
 */
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class GiftCardGive
 * @method getListByParams(array $params) 赠送列表【不分页】
 * @method giveByParams(array $params) 赠送
 * @method getInfoByParams(array $params) 获取礼品卡赠送记录详情
 * @method confirmGiveByParams(array $params) 确认赠送
 * @method cancelGiveByParams(array $params) 取消赠送
 * @method receiveByParams(array $params) 领取礼品卡
 */
class GiftCardGive {
    private static string $serviceName = "Preferential";

    private static string $className = "GiftCard\\GiftCardGive";

    /**
     * 赠送列表【不分页】
     * @return  array
    */
    public static function getList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getList([]);
    }
    /**
     * 赠送
     * @return  array
    */
    public static function give (int $give_user_id, int $gift_card_id, string $title) {
        return RpcClass::getClass(self::$serviceName, self::$className)->give(["give_user_id" => $give_user_id, "gift_card_id" => $gift_card_id, "title" => $title]);
    }
    /**
     * 获取礼品卡赠送记录详情
     * @return  array
    */
    public static function getInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfo(["id" => $id]);
    }
    /**
     * 确认赠送
     * @return  bool
    */
    public static function confirmGive (int $id, string $title) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmGive(["id" => $id, "title" => $title]);
    }
    /**
     * 取消赠送
     * @return  bool
    */
    public static function cancelGive (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelGive(["id" => $id]);
    }
    /**
     * 领取礼品卡
     * @return  bool
    */
    public static function receive (int $id, int $receive_user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receive(["id" => $id, "receive_user_id" => $receive_user_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}