<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-26 11:16:11
 */
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PhysicalProductCardOrder
 * @method createOrderByParams(array $params) 创建产品卡订单
 * @method passAuditByParams(array $params) 审核通过
 * @method refuseAuditByParams(array $params) 拒绝审核|撤销审核
 * @method passPayByParams(array $params) 支付通过
 */
class PhysicalProductCardOrder {
    private static string $serviceName = "Preferential";

    private static string $className = "Coupon\\PhysicalProductCardOrder";

    /**
     * 创建产品卡订单
     * @return  int
    */
    public static function createOrder (string $phone, int $userId, string $payType, array $cardIds, int $createBy, string $auditStatus, string $userName, float $oriMoney, string $buyChannel, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createOrder(["phone" => $phone, "userId" => $userId, "payType" => $payType, "cardIds" => $cardIds, "createBy" => $createBy, "auditStatus" => $auditStatus, "userName" => $userName, "oriMoney" => $oriMoney, "buyChannel" => $buyChannel, "extend" => $extend]);
    }
    /**
     * 审核通过
     * @return  int
    */
    public static function passAudit (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->passAudit(["orderId" => $orderId]);
    }
    /**
     * 拒绝审核|撤销审核
     * @return  int
    */
    public static function refuseAudit (int $orderId, string $auditStatus) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refuseAudit(["orderId" => $orderId, "auditStatus" => $auditStatus]);
    }
    /**
     * 支付通过
     * @return  int
    */
    public static function passPay (int $orderId, string $payType, string $paymentNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->passPay(["orderId" => $orderId, "payType" => $payType, "paymentNo" => $paymentNo]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}