<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-09-15 10:40:11
 */
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class GiftCardPayment
 */
class GiftCardPayment {
    private static string $serviceName = "Preferential";

    private static string $className = "GiftCard\\GiftCardPayment";

    /**
     * 预支付
     * @return  string
    */
    public static function prePay (int $outOrderId, float $money, int $userId, string $source, string $outOrderNo, string $payType = 'pay', array $attachInfo = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->prePay(["outOrderId" => $outOrderId, "money" => $money, "userId" => $userId, "source" => $source, "outOrderNo" => $outOrderNo, "payType" => $payType, "attachInfo" => $attachInfo]);
    }
    /**
     * 撤销预支付
     * @return  bool
    */
    public static function cancelPrePay (string $payment_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelPrePay(["payment_no" => $payment_no]);
    }
    /**
     * 确认预支付
     * @return  bool
    */
    public static function submitPrePay (string $payment_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitPrePay(["payment_no" => $payment_no]);
    }
    /**
     * 根据支付流水号获取支付详情
     * @return  array
    */
    public static function getPayDetailByPaymentNo (string $payment_no, bool $with_payment_items = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPayDetailByPaymentNo(["payment_no" => $payment_no, "with_payment_items" => $with_payment_items]);
    }
    /**
     * 根据订单号获取支付详情-作废
     * @return  array
    */
    public static function getPayDetailByOrderNo (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPayDetailByOrderNo(["order_no" => $order_no]);
    }
    /**
     * 根据订单号获取支付详情
     * @return  array
    */
    public static function getPaymentInfoByOrderNo (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPaymentInfoByOrderNo(["orderNo" => $orderNo]);
    }
    /**
     * 根据订单外部关联ID获取支付详情
     * @return  array
    */
    public static function getPaymentInfoByOrderId (int $outOrderId, string $source = 'himo') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPaymentInfoByOrderId(["outOrderId" => $outOrderId, "source" => $source]);
    }
    /**
     * 订单退款【礼品卡支付订单】
     * @return  mixed
    */
    public static function refund (float $money, string $payment_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refund(["money" => $money, "payment_no" => $payment_no]);
    }
    /**
     * 获取可退款礼品卡金额
     * @return  float
    */
    public static function getCanRefundMoney (string $payment_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCanRefundMoney(["payment_no" => $payment_no]);
    }
    /**
     * 更新适用订单【转门店】
     * @return  string
    */
    public static function updateTransferInfo (string $paymentNo, int $outOrderId, string $outOrderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateTransferInfo(["paymentNo" => $paymentNo, "outOrderId" => $outOrderId, "outOrderNo" => $outOrderNo]);
    }
    /**
     * 获取支付详情【包含是否礼品卡退款id】
     * @return  array
    */
    public static function getPaymentItemsWithRefundId (string $payment_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPaymentItemsWithRefundId(["payment_no" => $payment_no]);
    }
    /**
     * 获取礼品卡支付记录列表-废弃
     * @return  mixed
    */
    public static function getPaymentItems (int $page = 1, int $pageSize = 10, int $cardId, bool $withPaymentInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPaymentItems(["page" => $page, "pageSize" => $pageSize, "cardId" => $cardId, "withPaymentInfo" => $withPaymentInfo]);
    }
    /**
     * 获取礼品卡支付记录分页列表
     * @return  array
    */
    public static function getPaymentItemsPage (int $page = 1, int $pageSize = 10, int $cardId, string $status, bool $withPaymentInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPaymentItemsPage(["page" => $page, "pageSize" => $pageSize, "cardId" => $cardId, "status" => $status, "withPaymentInfo" => $withPaymentInfo]);
    }
    /**
     * 根据订单号查询获取使用的礼品卡(除去退款)
     * @return  array
    */
    public static function getUseGiftCardsByOrderNo (string $outOrderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUseGiftCardsByOrderNo(["outOrderNo" => $outOrderNo]);
    }
    /**
     * 获取礼品卡退款
     * @return  array
    */
    public static function getPaymentRefunds (array $ids, array $refundNums) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPaymentRefunds(["ids" => $ids, "refundNums" => $refundNums]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}