<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-06 10:20:13
 */
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductCardOrder
 */
class ProductCardOrder {
    private static string $serviceName = "Preferential";

    private static string $className = "Coupon\\ProductCardOrder";

    /**
     * 创建产品卡订单包含支付，接口已作废，请使用createVirtualCardOrder，createPhysicalCardOrder
     * @return  int
    */
    public static function create (string $sex, string $type, string $phone, int $user_id, string $pay_type, array $card_ids, int $store_id, int $create_by, string $user_name, float $ori_money, float $pay_money, string $buy_channel, string $payment_no, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["sex" => $sex, "type" => $type, "phone" => $phone, "user_id" => $user_id, "pay_type" => $pay_type, "card_ids" => $card_ids, "store_id" => $store_id, "create_by" => $create_by, "user_name" => $user_name, "ori_money" => $ori_money, "pay_money" => $pay_money, "buy_channel" => $buy_channel, "payment_no" => $payment_no, "extend" => $extend]);
    }
    /**
     * 创建产品卡订单【线上】
     * @return  int
    */
    public static function prepaidCreate (string $sex, string $phone, int $user_id, int $store_id, int $create_by, string $user_name, float $ori_money, float $pay_money, string $buy_channel, \Mainto\Bridge\Structs\Preferential\Coupon\ProductCardOrder\PrepaidCreateParamsExtend $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->prepaidCreate(["sex" => $sex, "phone" => $phone, "user_id" => $user_id, "store_id" => $store_id, "create_by" => $create_by, "user_name" => $user_name, "ori_money" => $ori_money, "pay_money" => $pay_money, "buy_channel" => $buy_channel, "extend" => $extend]);
    }
    /**
     * 产品卡订单支付
     * @return  int
    */
    public static function afterPay (int $order_id, string $pay_type, string $payment_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterPay(["order_id" => $order_id, "pay_type" => $pay_type, "payment_no" => $payment_no]);
    }
    /**
     * 获取列表
     * @return  array
    */
    public static function getOrders (int $page = 1, int $page_size = 10, string $type, string $phone, array $ids, string $status, int $store_id, string $pay_type, string $user_name, array $order_nums, string $create_end_at, string $create_start_at) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrders(["page" => $page, "page_size" => $page_size, "type" => $type, "phone" => $phone, "ids" => $ids, "status" => $status, "store_id" => $store_id, "pay_type" => $pay_type, "user_name" => $user_name, "order_nums" => $order_nums, "create_end_at" => $create_end_at, "create_start_at" => $create_start_at]);
    }
    /**
     * 获取详情
     * @return  array
    */
    public static function getInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfo(["id" => $id]);
    }
    /**
     * 通过订单号获取订单
     * @return  array
    */
    public static function getOrderByOrderNum (string $order_num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderByOrderNum(["order_num" => $order_num]);
    }
    /**
     * 通过订单号获取订单
     * @return  array
    */
    public static function getOrderByOrderNumWithItem (string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderByOrderNumWithItem(["orderNum" => $orderNum]);
    }
    /**
     * updateInvoiceId
     * @return  bool
    */
    public static function updateInvoiceId (array $order_nums, int $invoice_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateInvoiceId(["order_nums" => $order_nums, "invoice_id" => $invoice_id]);
    }
    /**
     * 修改支付方式
     * @return  bool
    */
    public static function changePayType (int $id, string $pay_type, array $extend, string $payment_no = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "pay_type" => $pay_type, "extend" => $extend, "payment_no" => $payment_no]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}