<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-07 14:25:41
 */
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Stock
 */
class Stock {
    private static string $serviceName = "Preferential";

    private static string $className = "Stock";

    /**
     * 调配
     * @return  bool
    */
    public static function allocate (string $type, array $detail, int $operator, int $stockStoreId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->allocate(["type" => $type, "detail" => $detail, "operator" => $operator, "stockStoreId" => $stockStoreId]);
    }
    /**
     * 库存查询-分页
     * @return  array
    */
    public static function getStocks (int $operate_id, int $store_id, bool $with_cover_info = false, string $type, bool $filter_zero_stock = true, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStocks(["operate_id" => $operate_id, "store_id" => $store_id, "with_cover_info" => $with_cover_info, "type" => $type, "filter_zero_stock" => $filter_zero_stock, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 获取库存记录列表-分页
     * @return  array
    */
    public static function getStockProducts (array $stock_ids, string $type, string $status, array $card_ids, int $store_id, bool $with_card_info = false, int $stock_operate_id, int $stock_money, int $page = 1, int $page_size = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockProducts(["stock_ids" => $stock_ids, "type" => $type, "status" => $status, "card_ids" => $card_ids, "store_id" => $store_id, "with_card_info" => $with_card_info, "stock_operate_id" => $stock_operate_id, "stock_money" => $stock_money, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 获取库存记录列表-不分页
     * @return  array
    */
    public static function listForStockProducts (string $type, string $status, array $cardIds, int $stockId, int $storeId, bool $withCardInfo = false, int $stockOperateId, int $stockMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listForStockProducts(["type" => $type, "status" => $status, "cardIds" => $cardIds, "stockId" => $stockId, "storeId" => $storeId, "withCardInfo" => $withCardInfo, "stockOperateId" => $stockOperateId, "stockMoney" => $stockMoney]);
    }
    /**
     * 获取库存记录列表-不分页
     * @return  array
    */
    public static function getStockProductsWithTrashed (string $type, array $cardIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockProductsWithTrashed(["type" => $type, "cardIds" => $cardIds]);
    }
    /**
     * 获取库存记录详情
     * @return  array
    */
    public static function info (int $id, string $type, bool $with_card_info = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->info(["id" => $id, "type" => $type, "with_card_info" => $with_card_info]);
    }
    /**
     * 获取库存详情信息
     * @return  array
    */
    public static function getStockProduct (int $cardId, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockProduct(["cardId" => $cardId, "type" => $type]);
    }
    /**
     * 锁定库存
     * @return  bool
    */
    public static function stockLock (int $storeId, array $cardIds, string $type, int $operator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stockLock(["storeId" => $storeId, "cardIds" => $cardIds, "type" => $type, "operator" => $operator]);
    }
    /**
     * 释放锁定库存
     * @return  bool
    */
    public static function releaseStockLock (int $storeId, array $cardIds, string $type, int $operator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->releaseStockLock(["storeId" => $storeId, "cardIds" => $cardIds, "type" => $type, "operator" => $operator]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}