<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-06-20 10:25:31
 */
namespace Mainto\Bridge\Structs\Preferential\GiftCard\Cmd;

class GiftCardGenerateDemandCmd {
    /**
     * @var  string
     * 标题
     * validation: max:15
     */
    public string $title;
    /**
     * @var  int
     * 卡面ID
     * validation: 
     */
    public int $coverId;
    /**
     * @var  int
     * 卡面额
     * validation: integer|min:1
     */
    public int $cardMoney;
    /**
     * @var  int
     * 数量
     * validation: min:1
     */
    public int $count;
    /**
     * @var  array
     * 扩展信息-原因
     * validation: 
     */
    public array $extend;
    /**
     * @var  string
     * 开始生效日期
     * validation: date_format:Y-m-d H:i:s|before:stopUsage
     */
    public string $startUsage;
    /**
     * @var  string
     * 失效日期
     * validation: date_format:Y-m-d H:i:s|after:startUsage
     */
    public string $stopUsage;
    /**
     * @var  null|int
     * 用户ID，注：当传userid时会自动充值券码
     * validation: 
     */
    public ?int $userId = null;

    public function __construct (string $title = '', int $coverId = 0, int $cardMoney = 0, int $count = 0, array $extend = [], string $startUsage = '', string $stopUsage = '') {
        $this->title = $title;
        $this->coverId = $coverId;
        $this->cardMoney = $cardMoney;
        $this->count = $count;
        $this->extend = $extend;
        $this->startUsage = $startUsage;
        $this->stopUsage = $stopUsage;
    }

    public static function create(string $title = '', int $coverId = 0, int $cardMoney = 0, int $count = 0, array $extend = [], string $startUsage = '', string $stopUsage = ''): self {
        return new self($title, $coverId, $cardMoney, $count, $extend, $startUsage, $stopUsage);
    }

    public function setTitle(string $title): self {
        $this->title = $title;

        return $this;
    }

    public function setCoverId(int $coverId): self {
        $this->coverId = $coverId;

        return $this;
    }

    public function setCardMoney(int $cardMoney): self {
        $this->cardMoney = $cardMoney;

        return $this;
    }

    public function setCount(int $count): self {
        $this->count = $count;

        return $this;
    }

    public function setExtend(array $extend): self {
        $this->extend = $extend;

        return $this;
    }

    public function setStartUsage(string $startUsage): self {
        $this->startUsage = $startUsage;

        return $this;
    }

    public function setStopUsage(string $stopUsage): self {
        $this->stopUsage = $stopUsage;

        return $this;
    }

    public function setUserId(?int $userId): self {
        $this->userId = $userId;

        return $this;
    }
}