<?php
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createRefundCardByParams(array $params)
 * @method generateAnniversaryCardByParams(array $params)
 * @method getCardInfoByParams(array $params)
 * @method getCardListByParams(array $params)
 * @method getCardListByPageByParams(array $params)
 * @method getUserBalanceByParams(array $params)
 * @method getUserValidDateByParams(array $params)
 * @method chargeByParams(array $params)
 * @method bindCardByParams(array $params)
 * @method abolishCardByParams(array $params)
 * @method transCardToWXCardByParams(array $params)
 * @method bindAndRemoveWXCardByParams(array $params)
 * @method getUserGiftCardPaymentLogsByParams(array $params)
 * @method delayByParams(array $params)
 * @method withdrawByParams(array $params)
 */
class GiftCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 这里主要用于满足将现金退款至新礼品卡的业务，是一种特殊场景
     * 生成的礼品卡不与订单关联，自动激活，这扣比例1:1
     * 生成记录也单独记录，不与礼品卡创建记录关联
     *
     * @param  float $money 记录标题 [ require true ]
     * @param  int $user_id 用户id [ require true ]
     * @param  int $out_refund_id 退款id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createRefundCard (int $user_id, float $money, int $out_refund_id) {
        return self::getClass()->createRefundCard([
            "user_id" => $user_id,
            "money" => $money,
            "out_refund_id" => $out_refund_id,
        ]);
    }

    /**
     * 生成伙伴周年庆卡(一张)
     *
     * @param  int $money 礼品卡面值 [ require true ]
     * @param  int $cover_id 礼品卡封面 [ require true ]
     * @param  string $stop_usage 结束日期 [ require true ]
     * @param  string $start_usage 开始日期 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function generateAnniversaryCard (int $cover_id, int $money, string $stop_usage, string $start_usage) {
        return self::getClass()->generateAnniversaryCard([
            "cover_id" => $cover_id,
            "money" => $money,
            "stop_usage" => $stop_usage,
            "start_usage" => $start_usage,
        ]);
    }

    /**
     * 获取详情
     *
     * @support  int $id id [ require false ]
     * @support  string $code 礼品卡code [ require false ]
     * @support  bool $with_cover_info 是否包含卡面信息 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCardInfo () {
        return self::getClass()->getCardInfo([
        ]);
    }

    /**
     * 获取列表
     *
     * @support  array $ids 礼品卡编号 [ require false ]
     * @support  bool $bound 是否已绑定 [ require false ]
     * @support  int $user_id 用户id [ require false ]
     * @support  int $old_user_id 原持有用户（赠送前）id [ require false ]
     * @support  int $card_id 卡片id [ require false ]
     * @support  string $code 礼品码 [ require false ]
     * @support  array $codes 礼品码组 [ require false ]
     * @support  float $money 面额 [ require false ]
     * @support  array $status 状态 [ require false ]
     * @support  array $give_status 赠送状态 [ require false ]
     * @support  int $create_log_id 生成记录id [ require false ]
     * @support  array $order_nums 多订单号查询 [ require false ]
     * @support  bool $with_cover_info 是否包含卡面信息 [ require false ]
     * @support  string $sort_field 排序字段 [ require false ]
     * @support  string $sort_direction 排序方向 [ require false ]
     * @support  string $created_at_start 生成时间起 [ require false ]
     * @support  string $created_at_end 生成时间止 [ require false ]
     * @support  string $code 礼品码 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCardList () {
        return self::getClass()->getCardList([
        ]);
    }

    /**
     * fixme status，give_status参数优化
     *
     * @support  array $ids 礼品卡ids [ require false ]
     * @support  bool $bound 是否已绑定 [ require false ]
     * @support  array $status 状态 [ require false ]
     * @support  array $give_status 赠送状态 [ require false ]
     * @support  int $user_id 用户id [ require false ]
     * @support  int $old_user_id 原持有用户（赠送前）id [ require false ]
     * @support  string $code 礼品码 [ require false ]
     * @support  int $create_log_id 生成记录id [ require false ]
     * @support  bool $with_cover_info 是否包含卡面信息 [ require false ]
     * @support  string $created_at_start 生成时间起 [ require false ]
     * @support  string $created_at_end 生成时间止 [ require false ]
     * @support  array $order_nums 购买订单号 [ require false ]
     * @support  array $sort_by 排序字段 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCardListByPage (int $page = 1, int $page_size = 10) {
        return self::getClass()->getCardListByPage([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取用户余额
     *
     * @param  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  double
     */
    public static function getUserBalance (int $user_id) {
        return self::getClass()->getUserBalance([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 获取用户礼品卡有效期
     *
     * @param  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getUserValidDate (int $user_id) {
        return self::getClass()->getUserValidDate([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 充值
     *
     * @param  int $user_id 用户id [ require true ]
     * @param  string $code 礼品码 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function charge (int $user_id, string $code) {
        return self::getClass()->charge([
            "user_id" => $user_id,
            "code" => $code,
        ]);
    }

    /**
     * 绑定礼品卡-转出礼品卡失败重新绑回赠送人账户
     *
     * @param  int $user_id 用户id [ require true ]
     * @param  string $code 礼品卡code [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bindCard (int $user_id, string $code) {
        return self::getClass()->bindCard([
            "user_id" => $user_id,
            "code" => $code,
        ]);
    }

    /**
     * 作废礼品码
     *
     * @support  array $codes 礼品码 [ require false ]
     * @support  array $cardIds 礼品卡ids [ require false ]
     * @support  int $operator 操作人-参数作废，计入extend [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function abolishCard () {
        return self::getClass()->abolishCard([
        ]);
    }

    /**
     * 转出礼品卡到微信卡包
     *
     * @param  string $scene 通道 [ require true ]
     * @param  int $user_id 用户id [ require true ]
     * @param  string $open_id openid [ require true ]
     * @param  string $cardId 卡id [ require true ]
     * @param  string $code 礼品卡code [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function transCardToWXCard (string $scene, int $user_id, string $open_id, string $cardId, string $code) {
        return self::getClass()->transCardToWXCard([
            "scene" => $scene,
            "user_id" => $user_id,
            "open_id" => $open_id,
            "cardId" => $cardId,
            "code" => $code,
        ]);
    }

    /**
     * 绑定微信卡包礼品卡
     *
     * @param  string $scene 通道 [ require true ]
     * @param  int $user_id 用户id [ require true ]
     * @param  string $cardId 卡id [ require true ]
     * @param  string $code 礼品卡code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindAndRemoveWXCard (string $scene, int $user_id, string $cardId, string $code) {
        return self::getClass()->bindAndRemoveWXCard([
            "scene" => $scene,
            "user_id" => $user_id,
            "cardId" => $cardId,
            "code" => $code,
        ]);
    }

    /**
     * 查询用户礼品卡消费记录
     *
     * @param  int $user_id 用户ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserGiftCardPaymentLogs (int $user_id) {
        return self::getClass()->getUserGiftCardPaymentLogs([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 礼品码延期
     *
     * @support  array $codes 礼品码 [ require true ]
     * @support  string $stop_usage 到期日期 [ require false ]
     * @support  mixed $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delay () {
        return self::getClass()->delay([
        ]);
    }

    /**
     * 注意：目前只有礼品卡转退（钱退款至礼品卡）一种场景支持提现，所以出于安全考虑，在这里做了限制，邀请必须有退款至新礼品卡的记录！！！
     * 后期如果完善礼品卡提现业务，可以对此进行重构
     *
     * @param  int $card_id 礼品卡ID [ require true ]
     * @param  float $money 提现金额 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function withdraw (int $card_id, float $money) {
        return self::getClass()->withdraw([
            "card_id" => $card_id,
            "money" => $money,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'GiftCard\GiftCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'GiftCard\GiftCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}