<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-12 14:30:43
 */
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class GiftCard
 */
class GiftCard {
    private static string $serviceName = "Preferential";

    private static string $className = "GiftCard\\GiftCard";

    /**
     * 退款生成礼品卡(一张)
     * @return  array
    */
    public static function createRefundCard (int $user_id, float $money, int $out_refund_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createRefundCard(["user_id" => $user_id, "money" => $money, "out_refund_id" => $out_refund_id]);
    }
    /**
     * 生成伙伴周年庆卡(一张)
     * @return  string
    */
    public static function generateAnniversaryCard (int $cover_id, int $money, string $stop_usage, string $start_usage) {
        return RpcClass::getClass(self::$serviceName, self::$className)->generateAnniversaryCard(["cover_id" => $cover_id, "money" => $money, "stop_usage" => $stop_usage, "start_usage" => $start_usage]);
    }
    /**
     * 获取详情
     * @return  array
    */
    public static function getCardInfo (int $id, string $code, bool $with_cover_info, bool $with_cover, bool $with_order_info, bool $with_log_info, bool $with_event_info) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCardInfo(["id" => $id, "code" => $code, "with_cover_info" => $with_cover_info, "with_cover" => $with_cover, "with_order_info" => $with_order_info, "with_log_info" => $with_log_info, "with_event_info" => $with_event_info]);
    }
    /**
     * 获取列表
     * @return  array
    */
    public static function getCardList (array $ids, bool $bound, int $user_id, int $old_user_id, int $card_id, string $code, array $codes, float $money, array $status, array $give_status, int $create_log_id, array $order_nums, bool $with_cover_info, string $sort_field, string $sort_direction, string $created_at_start, string $created_at_end) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCardList(["ids" => $ids, "bound" => $bound, "user_id" => $user_id, "old_user_id" => $old_user_id, "card_id" => $card_id, "code" => $code, "codes" => $codes, "money" => $money, "status" => $status, "give_status" => $give_status, "create_log_id" => $create_log_id, "order_nums" => $order_nums, "with_cover_info" => $with_cover_info, "sort_field" => $sort_field, "sort_direction" => $sort_direction, "created_at_start" => $created_at_start, "created_at_end" => $created_at_end]);
    }
    /**
     * 获取列表-分页
     * @return  array
    */
    public static function getCardListByPage (int $page = 1, int $page_size = 10, array $ids, bool $bound, array $status, array $give_status, int $user_id, int $old_user_id, string $code, int $create_log_id, bool $with_cover_info, bool $with_cover, bool $with_order_info, bool $with_log_info, string $created_at_start, string $created_at_end, array $order_nums, array $sort_by) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCardListByPage(["page" => $page, "page_size" => $page_size, "ids" => $ids, "bound" => $bound, "status" => $status, "give_status" => $give_status, "user_id" => $user_id, "old_user_id" => $old_user_id, "code" => $code, "create_log_id" => $create_log_id, "with_cover_info" => $with_cover_info, "with_cover" => $with_cover, "with_order_info" => $with_order_info, "with_log_info" => $with_log_info, "created_at_start" => $created_at_start, "created_at_end" => $created_at_end, "order_nums" => $order_nums, "sort_by" => $sort_by]);
    }
    /**
     * 获取用户余额
     * @return  float
    */
    public static function getUserBalance (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserBalance(["user_id" => $user_id]);
    }
    /**
     * 获取用户礼品卡有效期
     * @return  string
    */
    public static function getUserValidDate (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserValidDate(["user_id" => $user_id]);
    }
    /**
     * 充值
     * @return  bool
    */
    public static function charge (int $user_id, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->charge(["user_id" => $user_id, "code" => $code]);
    }
    /**
     * 绑定礼品卡-转出礼品卡失败重新绑回赠送人账户
     * @return  bool
    */
    public static function bindCard (int $user_id, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindCard(["user_id" => $user_id, "code" => $code]);
    }
    /**
     * 作废礼品码
     * @return  bool
    */
    public static function abolishCard (array $codes, array $cardIds, int $operator, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolishCard(["codes" => $codes, "cardIds" => $cardIds, "operator" => $operator, "extend" => $extend]);
    }
    /**
     * 转出礼品卡到微信卡包
     * @return  array
    */
    public static function transCardToWXCard (string $scene, int $user_id, string $open_id, string $cardId, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->transCardToWXCard(["scene" => $scene, "user_id" => $user_id, "open_id" => $open_id, "cardId" => $cardId, "code" => $code]);
    }
    /**
     * 绑定微信卡包礼品卡
     * @return  array
    */
    public static function bindAndRemoveWXCard (string $scene, int $user_id, string $cardId, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindAndRemoveWXCard(["scene" => $scene, "user_id" => $user_id, "cardId" => $cardId, "code" => $code]);
    }
    /**
     * 查询用户礼品卡消费记录，请参考：App\Interfaces\GiftCard\Controllers\GiftCardPaymentController
     * @return  array
    */
    public static function getUserGiftCardPaymentLogs (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserGiftCardPaymentLogs(["user_id" => $user_id]);
    }
    /**
     * 礼品码延期
     * @return  bool
    */
    public static function delay (array $codes, string $stop_usage, \Mainto\Bridge\Structs\Preferential\GiftCard\GiftCard\DelayParamsExtend $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delay(["codes" => $codes, "stop_usage" => $stop_usage, "extend" => $extend]);
    }
    /**
     * 礼品卡提现
     * @return  bool
    */
    public static function withdraw (int $card_id, float $money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->withdraw(["card_id" => $card_id, "money" => $money]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}