<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-28 14:35:00
 */
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class InteriorCoupon
 */
class InteriorCoupon {
    private static string $serviceName = "Preferential";

    private static string $className = "Coupon\\InteriorCoupon";

    /**
     * 获取优惠码折扣
     */
    public static function getCouponDiscountPrice (string $uuid, bool $verify_usability = false): float {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponDiscountPrice(["uuid" => $uuid, "verify_usability" => $verify_usability, ]);
    }
    /**
     * 获取列表
     */
    public static function list (array $uuids, array $multi_status, int $create_log_id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["uuids" => $uuids, "multi_status" => $multi_status, "create_log_id" => $create_log_id, ]);
    }
    /**
     * 获取列表-分页
     */
    public static function getCoupons (int $page = 1, int $page_size = 10, array $uuids, int $create_log_id, string $used_at_start, string $used_at_end, array $multi_status): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCoupons(["page" => $page, "page_size" => $page_size, "uuids" => $uuids, "create_log_id" => $create_log_id, "used_at_start" => $used_at_start, "used_at_end" => $used_at_end, "multi_status" => $multi_status, ]);
    }
    /**
     * 获取详情
     */
    public static function getInfo (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfo(["id" => $id, ]);
    }
    /**
     * 内部折扣码作废
     */
    public static function abolish (array $uuids, int $operator, array $extend): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolish(["uuids" => $uuids, "operator" => $operator, "extend" => $extend, ]);
    }
    /**
     * 优惠券延期
     */
    public static function delay (array $uuids, string $stop_usage, \Mainto\Bridge\Structs\Preferential\Coupon\InteriorCoupon\DelayParamsExtend $extend): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->delay(["uuids" => $uuids, "stop_usage" => $stop_usage, "extend" => $extend, ]);
    }
    /**
     * 使用开单折扣码
     */
    public static function use (string $uuid, float $money, int $store_id, int $order_diff_id, int $order_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->use(["uuid" => $uuid, "money" => $money, "store_id" => $store_id, "order_diff_id" => $order_diff_id, "order_id" => $order_id, ]);
    }
    /**
     * 撤销核销折扣码
     */
    public static function refund (int $orderDiffId, string $uuid): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->refund(["orderDiffId" => $orderDiffId, "uuid" => $uuid, ]);
    }
    /**
     * 退款核销折扣码
     */
    public static function interiorCouponRefund (string $uuid, int $orderDiffId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->interiorCouponRefund(["uuid" => $uuid, "orderDiffId" => $orderDiffId, ]);
    }
    /**
     * 更新适用订单【转门店】
     */
    public static function updateTransferInfo (int $id, int $newOrderId, int $newOrderDiffId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateTransferInfo(["id" => $id, "newOrderId" => $newOrderId, "newOrderDiffId" => $newOrderDiffId, ]);
    }
    /**
     * 重拍
     */
    public static function retake (int $id, int $newOrderId, int $newOrderDiffId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->retake(["id" => $id, "newOrderId" => $newOrderId, "newOrderDiffId" => $newOrderDiffId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}