<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-28 14:39:17
 */
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductCard
 */
class ProductCard {
    private static string $serviceName = "Preferential";

    private static string $className = "Coupon\\ProductCard";

    /**
     * 批量创建产品卡
     */
    public static function bulkGenerateCards (int $count = 1, string $status, int $userId, int $channel, string $stopUsage, string $startUsage, int $templateId, array $extend, array $logUniqueByFields, int $generateChannel, int $channelId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkGenerateCards(["count" => $count, "status" => $status, "userId" => $userId, "channel" => $channel, "stopUsage" => $stopUsage, "startUsage" => $startUsage, "templateId" => $templateId, "extend" => $extend, "logUniqueByFields" => $logUniqueByFields, "generateChannel" => $generateChannel, "channelId" => $channelId, ]);
    }
    /**
     * 批量生成绑定多用户产品卡
     */
    public static function bulkGenerateMultiUserCards (array $phones, array $userIds, string $status, int $channel, int $createBy, string $stopUsage, string $startUsage, int $templateId, int $generateChannel, int $channelId, array $extend): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkGenerateMultiUserCards(["phones" => $phones, "userIds" => $userIds, "status" => $status, "channel" => $channel, "createBy" => $createBy, "stopUsage" => $stopUsage, "startUsage" => $startUsage, "templateId" => $templateId, "generateChannel" => $generateChannel, "channelId" => $channelId, "extend" => $extend, ]);
    }
    /**
     * 获取列表
     */
    public static function list (array $ids, array $codes, string $status, int $user_id, string $apply_in, array $order_ids, string $used_at_end, array $multi_status, int $create_log_id, string $used_at_start, string $created_at_end, string $created_at_start, bool $with_template_info, bool $with_log_info): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["ids" => $ids, "codes" => $codes, "status" => $status, "user_id" => $user_id, "apply_in" => $apply_in, "order_ids" => $order_ids, "used_at_end" => $used_at_end, "multi_status" => $multi_status, "create_log_id" => $create_log_id, "used_at_start" => $used_at_start, "created_at_end" => $created_at_end, "created_at_start" => $created_at_start, "with_template_info" => $with_template_info, "with_log_info" => $with_log_info, ]);
    }
    /**
     * 获取列表-分页
     */
    public static function getCards (array $ids, array $codes, int $user_id, string $apply_in, array $apply_ins, array $order_ids, array $sort_scope, int $template_id, array $multi_status, string $used_at_end, string $used_at_start, int $create_log_id, string $created_at_end, string $created_at_start, bool $with_template_info, bool $with_log_info, int $product_group_id, int $product_id, int $service_product_id, int $store_dimension_id, string $description, string $sort_field, string $sort_direction, int $page = 1, int $page_size = 10): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCards(["ids" => $ids, "codes" => $codes, "user_id" => $user_id, "apply_in" => $apply_in, "apply_ins" => $apply_ins, "order_ids" => $order_ids, "sort_scope" => $sort_scope, "template_id" => $template_id, "multi_status" => $multi_status, "used_at_end" => $used_at_end, "used_at_start" => $used_at_start, "create_log_id" => $create_log_id, "created_at_end" => $created_at_end, "created_at_start" => $created_at_start, "with_template_info" => $with_template_info, "with_log_info" => $with_log_info, "product_group_id" => $product_group_id, "product_id" => $product_id, "service_product_id" => $service_product_id, "store_dimension_id" => $store_dimension_id, "description" => $description, "sort_field" => $sort_field, "sort_direction" => $sort_direction, "page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 详情
     */
    public static function info (int $id, string $code, bool $withLogInfo = false, bool $withTemplateInfo = true, bool $withOrderInfo = false): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->info(["id" => $id, "code" => $code, "withLogInfo" => $withLogInfo, "withTemplateInfo" => $withTemplateInfo, "withOrderInfo" => $withOrderInfo, ]);
    }
    /**
     * 产品卡延期
     */
    public static function delay (array $codes, string $stop_usage, \Mainto\Bridge\Structs\Preferential\Coupon\ProductCard\DelayParamsExtend $extend): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->delay(["codes" => $codes, "stop_usage" => $stop_usage, "extend" => $extend, ]);
    }
    /**
     * 更新适用订单【转门店】
     */
    public static function updateTransferInfo (int $id, int $newOrderId, int $newOrderDiffId = null): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateTransferInfo(["id" => $id, "newOrderId" => $newOrderId, "newOrderDiffId" => $newOrderDiffId, ]);
    }
    /**
     * 获得用户产品卡
     */
    public static function getUserCards (int $user_id, string $status, string $apply_in, array $apply_ins, bool $with_template_info): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserCards(["user_id" => $user_id, "status" => $status, "apply_in" => $apply_in, "apply_ins" => $apply_ins, "with_template_info" => $with_template_info, ]);
    }
    /**
     * 标记用户券是否可用
     */
    public static function markUserCards (int $userId, array $products, int $storeId, string $applyIn): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->markUserCards(["userId" => $userId, "products" => $products, "storeId" => $storeId, "applyIn" => $applyIn, ]);
    }
    /**
     * 获得产品卡可折扣金额
     */
    public static function getCardDiscountPrice (int $cardId, array $nodeInfo): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCardDiscountPrice(["cardId" => $cardId, "nodeInfo" => $nodeInfo, ]);
    }
    /**
     * 使用产品卡
     */
    public static function use (int $id, int $user_id, int $order_id, int $order_diff_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->use(["id" => $id, "user_id" => $user_id, "order_id" => $order_id, "order_diff_id" => $order_diff_id, ]);
    }
    /**
     * 产品卡绑定
     */
    public static function bind (int $user_id, string $code): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->bind(["user_id" => $user_id, "code" => $code, ]);
    }
    /**
     * 产品卡绑定-批量
     */
    public static function batchBind (int $userId, array $codes): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchBind(["userId" => $userId, "codes" => $codes, ]);
    }
    /**
     * 退款返回产品卡
     */
    public static function refund (int $id, int $user_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->refund(["id" => $id, "user_id" => $user_id, ]);
    }
    /**
     * 作废产品卡-已作废
     */
    public static function abolishCards (array $codes, int $operator, array $extend): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolishCards(["codes" => $codes, "operator" => $operator, "extend" => $extend, ]);
    }
    /**
     * 作废产品卡
     */
    public static function abolishProductCards (array $codes, array $cardIds, int $operator, string $reason): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolishProductCards(["codes" => $codes, "cardIds" => $cardIds, "operator" => $operator, "reason" => $reason, ]);
    }
    /**
     * 用户退回产品券【返回赠送券-生日照】
     */
    public static function return (string $code, int $user_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->return(["code" => $code, "user_id" => $user_id, ]);
    }
    /**
     * 渠道统计
     */
    public static function statisticCards (int $channel): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->statisticCards(["channel" => $channel, ]);
    }
    /**
     * 产品券替换
     */
    public static function replace (int $cardId, string $type, int $userId, int $templateId, bool $abolishOriginal = true): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->replace(["cardId" => $cardId, "type" => $type, "userId" => $userId, "templateId" => $templateId, "abolishOriginal" => $abolishOriginal, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}