<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-22 15:43:03
 */
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class GiftCardOrder
 */
class GiftCardOrder {
    private static string $serviceName = "Preferential";

    private static string $className = "GiftCard\\GiftCardOrder";

    /**
     * 管理端售卖礼品卡
     */
    public static function managerCreate (string $sex, string $type, string $phone, int $user_id, array $card_ids, string $pay_type, int $store_id, string $user_name, float $ori_money, float $pay_money, int $create_by, string $buy_channel, array $extend): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->managerCreate(["sex" => $sex, "type" => $type, "phone" => $phone, "user_id" => $user_id, "card_ids" => $card_ids, "pay_type" => $pay_type, "store_id" => $store_id, "user_name" => $user_name, "ori_money" => $ori_money, "pay_money" => $pay_money, "create_by" => $create_by, "buy_channel" => $buy_channel, "extend" => $extend, ]);
    }
    /**
     * 用户购买礼品卡【线上】
     */
    public static function userCreate (string $phone, array $extend, int $user_id, string $user_name, float $pay_money, array $card_item): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->userCreate(["phone" => $phone, "extend" => $extend, "user_id" => $user_id, "user_name" => $user_name, "pay_money" => $pay_money, "card_item" => $card_item, ]);
    }
    /**
     * 礼品卡订单支付【线上支付|线下拉卡拉支付】
     */
    public static function afterPay (int $order_id, string $pay_type, string $payment_no): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterPay(["order_id" => $order_id, "pay_type" => $pay_type, "payment_no" => $payment_no, ]);
    }
    /**
     * 创建礼品卡订单【未支付订单】- 线上
     */
    public static function prepaidCreate (string $sex, string $phone, int $user_id, int $store_id, int $create_by, string $user_name, float $ori_money, float $pay_money, string $buy_channel, \Mainto\Bridge\Structs\Preferential\GiftCard\GiftCardOrder\PrepaidCreateParamsExtend $extend): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->prepaidCreate(["sex" => $sex, "phone" => $phone, "user_id" => $user_id, "store_id" => $store_id, "create_by" => $create_by, "user_name" => $user_name, "ori_money" => $ori_money, "pay_money" => $pay_money, "buy_channel" => $buy_channel, "extend" => $extend, ]);
    }
    /**
     * 礼品卡订单支付类型
     */
    public static function getPayTypes (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPayTypes();
    }
    /**
     * 获取列表
     */
    public static function getList (string $order_num, array $order_nums, int $store_id, int $user_id, string $type, bool $with_items, array $card_ids, string $status): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getList(["order_num" => $order_num, "order_nums" => $order_nums, "store_id" => $store_id, "user_id" => $user_id, "type" => $type, "with_items" => $with_items, "card_ids" => $card_ids, "status" => $status, ]);
    }
    /**
     * 获取列表-分页
     */
    public static function getListByPage (int $store_id, int $user_id, string $user_name, array $order_nums, string $phone, string $type, string $start_at, string $end_at, string $pay_type, string $status, bool $with_items, int $page = 1, int $page_size = 10): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListByPage(["store_id" => $store_id, "user_id" => $user_id, "user_name" => $user_name, "order_nums" => $order_nums, "phone" => $phone, "type" => $type, "start_at" => $start_at, "end_at" => $end_at, "pay_type" => $pay_type, "status" => $status, "with_items" => $with_items, "page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 获取详情
     */
    public static function getInfo (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfo(["id" => $id, ]);
    }
    /**
     * 根据订单号获取详情
     */
    public static function getInfoByNo (string $order_no): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfoByNo(["order_no" => $order_no, ]);
    }
    /**
     * updateInvoiceId
     */
    public static function updateInvoiceId (int $invoice_id, array $order_nums): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateInvoiceId(["invoice_id" => $invoice_id, "order_nums" => $order_nums, ]);
    }
    /**
     * 修改支付方式
     */
    public static function changePayType (int $id, string $pay_type, string $payment_no, array $extend): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "pay_type" => $pay_type, "payment_no" => $payment_no, "extend" => $extend, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}