<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-14 16:41:53
 */
namespace Mainto\Bridge\Structs\Preferential\GiftCard\Cmd;

class UserCardCreateCmd {
    /**
     * @var  string
     * 标题
     * validation: min:1
     */
    public string $title;
    /**
     * @var  int
     * 用户ID
     * validation: integer|min:1
     */
    public int $userId;
    /**
     * @var  array
     * 扩展信息-原因
     * validation: 
     */
    public array $extend;
    /**
     * @var  int
     * 卡面ID
     * validation: 
     */
    public int $coverId;
    /**
     * @var  int
     * 创建人
     * validation: 
     */
    public int $createBy;
    /**
     * @var  int
     * 创建数量
     * validation: sometimes|integer|min:1
     */
    public int $count = 1;
    /**
     * @var  float
     * 面值
     * validation: numeric|gt:0
     */
    public float $money;
    /**
     * @var  int
     * 渠道ID
     * validation: required|min:1|integer
     */
    public int $channelId;
    /**
     * @var  string
     * 开始时间
     * validation: 
     */
    public string $startUsage;
    /**
     * @var  string
     * 截止时间
     * validation: required|after:startUsage
     */
    public string $stopUsage;

    public function __construct (string $title = '', int $userId = 0, array $extend = [], int $coverId = 0, int $createBy = 0, float $money = 0.0, int $channelId = 0, string $startUsage = '', string $stopUsage = '') {
        $this->title = $title;
        $this->userId = $userId;
        $this->extend = $extend;
        $this->coverId = $coverId;
        $this->createBy = $createBy;
        $this->money = $money;
        $this->channelId = $channelId;
        $this->startUsage = $startUsage;
        $this->stopUsage = $stopUsage;
    }

    public static function create(string $title = '', int $userId = 0, array $extend = [], int $coverId = 0, int $createBy = 0, float $money = 0.0, int $channelId = 0, string $startUsage = '', string $stopUsage = ''): self {
        return new self($title, $userId, $extend, $coverId, $createBy, $money, $channelId, $startUsage, $stopUsage);
    }

    public function setTitle(string $title): self {
        $this->title = $title;

        return $this;
    }

    public function setUserId(int $userId): self {
        $this->userId = $userId;

        return $this;
    }

    public function setExtend(array $extend): self {
        $this->extend = $extend;

        return $this;
    }

    public function setCoverId(int $coverId): self {
        $this->coverId = $coverId;

        return $this;
    }

    public function setCreateBy(int $createBy): self {
        $this->createBy = $createBy;

        return $this;
    }

    public function setCount(int $count): self {
        $this->count = $count;

        return $this;
    }

    public function setMoney(float $money): self {
        $this->money = $money;

        return $this;
    }

    public function setChannelId(int $channelId): self {
        $this->channelId = $channelId;

        return $this;
    }

    public function setStartUsage(string $startUsage): self {
        $this->startUsage = $startUsage;

        return $this;
    }

    public function setStopUsage(string $stopUsage): self {
        $this->stopUsage = $stopUsage;

        return $this;
    }
}