<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-14 16:41:53
 */
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Coupon
 */
class Coupon {
    private static string $serviceName = "Preferential";

    private static string $className = "Coupon\\Coupon";

    /**
     * 批量生成优惠券
     *
     */
    public static function bulkGenerateCoupons (int $count, string $title, string $status, int $channel, int $userId, float $discount, float $oriMoney, float $payMoney, int $createBy, string $stopUsage, int $templateId, string $buyChannel, int $channelId, string $startUsage, int $saleStoreId, array $extend, array $logUniqueByFields): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkGenerateCoupons(["count" => $count, "title" => $title, "status" => $status, "channel" => $channel, "userId" => $userId, "discount" => $discount, "oriMoney" => $oriMoney, "payMoney" => $payMoney, "createBy" => $createBy, "stopUsage" => $stopUsage, "templateId" => $templateId, "buyChannel" => $buyChannel, "channelId" => $channelId, "startUsage" => $startUsage, "saleStoreId" => $saleStoreId, "extend" => $extend, "logUniqueByFields" => $logUniqueByFields, ]);
    }
    /**
     * 批量生成绑定多用户券码
     *
     */
    public static function bulkGenerateMultiUserCoupons (array $phones, array $userIds, string $title = '批量送券', string $status, int $channel, float $discount, int $createBy, float $oriMoney = 0, float $payMoney, string $stopUsage, string $startUsage, int $templateId, string $buyChannel, int $channelId, array $extend, int $saleStoreId, array $logUniqueByFields): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkGenerateMultiUserCoupons(["phones" => $phones, "userIds" => $userIds, "title" => $title, "status" => $status, "channel" => $channel, "discount" => $discount, "createBy" => $createBy, "oriMoney" => $oriMoney, "payMoney" => $payMoney, "stopUsage" => $stopUsage, "startUsage" => $startUsage, "templateId" => $templateId, "buyChannel" => $buyChannel, "channelId" => $channelId, "extend" => $extend, "saleStoreId" => $saleStoreId, "logUniqueByFields" => $logUniqueByFields, ]);
    }
    /**
     * 获取列表
     *
     */
    public static function list (array $ids, string $type, array $codes, string $status, int $user_id, int $channel, string $apply_in, array $apply_ins, string $used_at_end, array $multi_status, string $used_at_start, int $create_log_id, array $order_ids, array $order_diff_ids, string $created_at_end, string $created_at_start, bool $with_template_info, bool $with_log_info): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["ids" => $ids, "type" => $type, "codes" => $codes, "status" => $status, "user_id" => $user_id, "channel" => $channel, "apply_in" => $apply_in, "apply_ins" => $apply_ins, "used_at_end" => $used_at_end, "multi_status" => $multi_status, "used_at_start" => $used_at_start, "create_log_id" => $create_log_id, "order_ids" => $order_ids, "order_diff_ids" => $order_diff_ids, "created_at_end" => $created_at_end, "created_at_start" => $created_at_start, "with_template_info" => $with_template_info, "with_log_info" => $with_log_info, ]);
    }
    /**
     * 获取列表-分页
     *
     */
    public static function getCoupons (array $ids, string $type, array $codes, string $status, int $user_id, string $apply_in, array $apply_ins, int $template_id, string $used_at_end, array $multi_status, int $create_log_id, string $used_at_start, string $created_at_end, string $created_at_start, bool $with_template_info, bool $with_log_info, int $product_group_id, int $product_id, int $store_dimension_id, bool $action_scope, string $description, string $sort_field, string $sort_direction, int $page = 1, int $page_size = 10): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCoupons(["ids" => $ids, "type" => $type, "codes" => $codes, "status" => $status, "user_id" => $user_id, "apply_in" => $apply_in, "apply_ins" => $apply_ins, "template_id" => $template_id, "used_at_end" => $used_at_end, "multi_status" => $multi_status, "create_log_id" => $create_log_id, "used_at_start" => $used_at_start, "created_at_end" => $created_at_end, "created_at_start" => $created_at_start, "with_template_info" => $with_template_info, "with_log_info" => $with_log_info, "product_group_id" => $product_group_id, "product_id" => $product_id, "store_dimension_id" => $store_dimension_id, "action_scope" => $action_scope, "description" => $description, "sort_field" => $sort_field, "sort_direction" => $sort_direction, "page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 获取详情
     *
     */
    public static function info (int $id, string $code, bool $withLogInfo = false, bool $withTemplateInfo = true): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->info(["id" => $id, "code" => $code, "withLogInfo" => $withLogInfo, "withTemplateInfo" => $withTemplateInfo, ]);
    }
    /**
     * 优惠券延期
     *
     */
    public static function delay (array $codes, string $stop_usage, \Mainto\Bridge\Structs\Preferential\Coupon\Coupon\DelayParamsExtend $extend): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->delay(["codes" => $codes, "stop_usage" => $stop_usage, "extend" => $extend, ]);
    }
    /**
     * 更新适用订单【转门店】
     *
     */
    public static function updateTransferInfo (int $couponId, int $newOrderId, int $newOrderDiffId = null): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateTransferInfo(["couponId" => $couponId, "newOrderId" => $newOrderId, "newOrderDiffId" => $newOrderDiffId, ]);
    }
    /**
     * 获得用户优惠券
     *
     */
    public static function getUserCoupons (int $user_id, string $status, string $apply_in, array $apply_ins, bool $with_template_info): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserCoupons(["user_id" => $user_id, "status" => $status, "apply_in" => $apply_in, "apply_ins" => $apply_ins, "with_template_info" => $with_template_info, ]);
    }
    /**
     * 标记用户券是否可用
     *
     */
    public static function markUserCoupons (int $userId, array $products, int $storeId, string $applyIn): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->markUserCoupons(["userId" => $userId, "products" => $products, "storeId" => $storeId, "applyIn" => $applyIn, ]);
    }
    /**
     * 使用优惠券
     *
     */
    public static function use (int $id, int $user_id, int $order_id, int $order_diff_id = null): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->use(["id" => $id, "user_id" => $user_id, "order_id" => $order_id, "order_diff_id" => $order_diff_id, ]);
    }
    /**
     * 获得优惠券可折扣金额
     *
     */
    public static function getCouponDiscountPrice (int $couponId, array $nodeInfo): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponDiscountPrice(["couponId" => $couponId, "nodeInfo" => $nodeInfo, ]);
    }
    /**
     * 加修加印券和加印券可折扣金额
     *
     */
    public static function getSpecialCouponDiscount (int $couponId, float $perPrice): float {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSpecialCouponDiscount(["couponId" => $couponId, "perPrice" => $perPrice, ]);
    }
    /**
     * 绑定优惠券
     *
     */
    public static function bind (int $user_id, string $code): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->bind(["user_id" => $user_id, "code" => $code, ]);
    }
    /**
     * 退款返回优惠券
     *
     */
    public static function refund (int $coupon_id, int $user_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->refund(["coupon_id" => $coupon_id, "user_id" => $user_id, ]);
    }
    /**
     * 作废优惠券
     *
     */
    public static function abolishCoupons (array $ids, array $codes, string $type, int $operator, array $extend): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolishCoupons(["ids" => $ids, "codes" => $codes, "type" => $type, "operator" => $operator, "extend" => $extend, ]);
    }
    /**
     * 渠道统计
     *
     */
    public static function statisticCoupons (int $channel): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->statisticCoupons(["channel" => $channel, ]);
    }
    /**
     * 创建记录统计
     *
     */
    public static function statisticCouponsByLogIds (array $logIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->statisticCouponsByLogIds(["logIds" => $logIds, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}