<?php
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array $params)
 * @method passAuditByParams(array $params)
 * @method refuseAuditByParams(array $params)
 * @method passPayByParams(array $params)
 */
class PhysicalProductCardOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品卡订单
     *
     * @support  string $sex 性别 [ require false ]
     * @support  string $phone 手机号 [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @support  string $payType 支付方式 [ require true ]
     * @support  array $cardIds 卡IDs [ require true ]
     * @support  int $storeId 门店id [ require false ]
     * @support  int $createBy 创建人 [ require true ]
     * @support  string $auditStatus 审核状态 [ require true ]
     * @support  string $userName 用户名 [ require true ]
     * @support  float $oriMoney 原价金额 [ require true ]
     * @support  float $payMoney 实付金额 [ require false ]
     * @support  string $buyChannel 购买渠道 [ require true ]
     * @support  string $paymentNo 支付流水号 [ require false ]
     * @support  array $extend 拓展信息 [ require false ]
     * @throws  \Exception
     * @return  int
     */
    public static function createOrder () {
        return self::getClass()->createOrder([
        ]);
    }

    /**
     * 审核通过
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function passAudit (int $orderId) {
        return self::getClass()->passAudit([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 拒绝审核|撤销审核
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $auditStatus 审核状态 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function refuseAudit (int $orderId, string $auditStatus) {
        return self::getClass()->refuseAudit([
            "orderId" => $orderId,
            "auditStatus" => $auditStatus,
        ]);
    }

    /**
     * 支付通过
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function passPay (int $orderId, string $payType, string $paymentNo) {
        return self::getClass()->passPay([
            "orderId" => $orderId,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Coupon\PhysicalProductCardOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Coupon\PhysicalProductCardOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}