<?php
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method retakePrePayByParams(array $params)
 * @method retakeRefundByParams(array $params)
 * @method retakeSubmitPrePayByParams(array $params)
 */
class GiftCardPaymentRetake {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预支付
     *
     * @support  mixed $cardItems 预支付明细 [ require true ]
     * @support  int $userId 用户ID [ require true ]
     * @support  int $outOrderId 外部关联订单ID [ require true ]
     * @support  string $outOrderNo 外部关联订单号 [ require true ]
     * @support  string $source 支付来源 [ require false ]
     * @support  string $payType 支付类型 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function retakePrePay () {
        return self::getClass()->retakePrePay([
        ]);
    }

    /**
     * 重拍订单退款【礼品卡支付订单】
     *
     * @param  float $money 退款金额 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function retakeRefund (float $money, string $paymentNo) {
        return self::getClass()->retakeRefund([
            "money" => $money,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 重拍确认预支付
     *
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function retakeSubmitPrePay (string $paymentNo) {
        return self::getClass()->retakeSubmitPrePay([
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'GiftCard\GiftCardPaymentRetake');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'GiftCard\GiftCardPaymentRetake');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}