<?php
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCouponDiscountPriceByParams(array $params)
 * @method listByParams(array $params)
 * @method getCouponsByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method abolishByParams(array $params)
 * @method delayByParams(array $params)
 * @method useByParams(array $params)
 * @method refundByParams(array $params)
 * @method interiorCouponRefundByParams(array $params)
 * @method updateTransferInfoByParams(array $params)
 * @method retakeByParams(array $params)
 */
class InteriorCoupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取优惠码折扣
     *
     * @param  string $uuid 优惠码 [ require true ]
     * @param  bool $verify_usability 验证可用性 [ require false ]
     * @throws  \Exception
     * @return  double
     */
    public static function getCouponDiscountPrice (string $uuid, bool $verify_usability = false) {
        return self::getClass()->getCouponDiscountPrice([
            "uuid" => $uuid,
            "verify_usability" => $verify_usability,
        ]);
    }

    /**
     * 获取列表
     *
     * @support  array $uuids 内部折扣uuids [ require false ]
     * @support  array $multi_status 状态 [ require false ]
     * @support  int $create_log_id 记录id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 获取列表-分页
     *
     * @support  array $uuids uuids [ require false ]
     * @support  int $create_log_id 记录id [ require false ]
     * @support  string $used_at_start 使用时间开始 [ require false ]
     * @support  string $used_at_end 使用时间截止 [ require false ]
     * @support  array $multi_status 状态 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页显示数量 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCoupons (int $page = 1, int $page_size = 10) {
        return self::getClass()->getCoupons([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取详情
     *
     * @param  int $id 折扣码id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * 内部折扣码作废
     *
     * @param  array $uuids uuids [ require true ]
     * @support  int $operator 操作人-待作废，参数写入extend [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function abolish (array $uuids) {
        return self::getClass()->abolish([
            "uuids" => $uuids,
        ]);
    }

    /**
     * 优惠券延期
     *
     * @param  array $uuids uuids [ require true ]
     * @support  string $stop_usage 到期日期 [ require false ]
     * @support  mixed $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delay (array $uuids) {
        return self::getClass()->delay([
            "uuids" => $uuids,
        ]);
    }

    /**
     * 使用开单折扣码
     *
     * @param  string $uuid uuid [ require true ]
     * @param  float $money 抵扣金额 [ require true ]
     * @param  int $store_id 使用门店id [ require true ]
     * @param  int $order_id 订单ID [ require true ]
     * @param  int $order_diff_id 订单diff—id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function use (string $uuid, float $money, int $store_id, int $order_diff_id, int $order_id) {
        return self::getClass()->use([
            "uuid" => $uuid,
            "money" => $money,
            "store_id" => $store_id,
            "order_diff_id" => $order_diff_id,
            "order_id" => $order_id,
        ]);
    }

    /**
     * 撤销核销折扣码
     *
     * @param  string $uuid uuid [ require true ]
     * @param  int $orderDiffId 订单diff-id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function refund (int $orderDiffId, string $uuid) {
        return self::getClass()->refund([
            "orderDiffId" => $orderDiffId,
            "uuid" => $uuid,
        ]);
    }

    /**
     * 退款核销折扣码
     *
     * @param  string $uuid uuid [ require true ]
     * @param  int $orderDiffId 订单diff-id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function interiorCouponRefund (string $uuid, int $orderDiffId) {
        return self::getClass()->interiorCouponRefund([
            "uuid" => $uuid,
            "orderDiffId" => $orderDiffId,
        ]);
    }

    /**
     * 更新适用订单【转门店】
     *
     * @param  int $id 开单折扣码ID [ require true ]
     * @param  int $newOrderId 新订单id [ require true ]
     * @param  int $newOrderDiffId 新订单diff-id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateTransferInfo (int $id, int $newOrderId, int $newOrderDiffId) {
        return self::getClass()->updateTransferInfo([
            "id" => $id,
            "newOrderId" => $newOrderId,
            "newOrderDiffId" => $newOrderDiffId,
        ]);
    }

    /**
     * 重拍
     *
     * @param  int $id 开单折扣码ID [ require true ]
     * @param  int $newOrderId 新订单id [ require true ]
     * @param  int $newOrderDiffId 新订单diff-id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function retake (int $id, int $newOrderId, int $newOrderDiffId) {
        return self::getClass()->retake([
            "id" => $id,
            "newOrderId" => $newOrderId,
            "newOrderDiffId" => $newOrderDiffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Coupon\InteriorCoupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Coupon\InteriorCoupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}