<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updateExpireGiftCardsByParams(array $params)
 * @method updateExpireCouponsByParams(array $params)
 * @method updateExpireProductCardsByParams(array $params)
 * @method updateExpireInteriorByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更新过期礼品卡
     *
     * @throws  \Exception
     * @return  void
     */
    public static function updateExpireGiftCards () {
        return self::getClass()->updateExpireGiftCards();
    }

    /**
     * 更新过期优惠券
     *
     * @throws  \Exception
     * @return  void
     */
    public static function updateExpireCoupons () {
        return self::getClass()->updateExpireCoupons();
    }

    /**
     * 更新过期礼品卡
     *
     * @throws  \Exception
     * @return  void
     */
    public static function updateExpireProductCards () {
        return self::getClass()->updateExpireProductCards();
    }

    /**
     * 更新过期内部折扣码
     *
     * @throws  \Exception
     * @return  void
     */
    public static function updateExpireInterior () {
        return self::getClass()->updateExpireInterior();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}