<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bulkGenerateCouponsByParams(array|\Mainto\Bridge\Structs\Preferential\InteriorCoupon\Cmd\InteriorCouponCreateCmd $params)
 */
class InteriorCouponV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 开单折扣码创建
     *
     * @var  \Mainto\Bridge\Structs\Preferential\InteriorCoupon\Cmd\InteriorCouponCreateCmd $cmd
     * @throws  \Exception
     * @return  int
     */
    public static function bulkGenerateCoupons (\Mainto\Bridge\Structs\Preferential\InteriorCoupon\Cmd\InteriorCouponCreateCmd $cmd) {
        return self::getClass()->bulkGenerateCoupons($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'InteriorCouponV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'InteriorCouponV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}