<?php
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bulkBindByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量绑定
     *
     * @param  int $user_id 用户ID [ require true ]
     * @param  array $card_ids 产品卡IDs [ require false ]
     * @param  array $coupon_ids 优惠券IDs [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bulkBind (int $user_id, array $card_ids = [], array $coupon_ids = []) {
        return self::getClass()->bulkBind([
            "user_id" => $user_id,
            "card_ids" => $card_ids,
            "coupon_ids" => $coupon_ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Coupon\Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Coupon\Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}