<?php
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByParams(array $params)
 * @method getListByPageByParams(array $params)
 */
class GiftCardSeries {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @param  string $title 标题 [ require true ]
     * @param  int $sequence 排序值 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create (string $title, int $sequence = 0) {
        return self::getClass()->create([
            "title" => $title,
            "sequence" => $sequence,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $id id [ require true ]
     * @support  string $title 标题 [ require false ]
     * @support  int $sequence 排序值 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 获取详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * 获取列表
     *
     * @param  string $title 标题 [ require false ]
     * @support  bool $has_topic_info 是否返回主题信息 [ require false ]
     * @support  bool $has_topic_and_cover 是否返回主题和卡面 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (string $title = '') {
        return self::getClass()->getList([
            "title" => $title,
        ]);
    }

    /**
     * 获取列表-分页
     *
     * @support  string $title 标题 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页条数 [ require false ]
     * @support  bool $has_topic_info 是否返回主题信息 [ require false ]
     * @support  bool $has_topic_and_cover 是否返回主题和卡面 [ require false ]
     * @param  bool $cover_on_sale 是否在售【默认查询在售】 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (bool $cover_on_sale = true, int $page = 1, int $page_size = 10) {
        return self::getClass()->getListByPage([
            "cover_on_sale" => $cover_on_sale,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'GiftCard\GiftCardSeries');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'GiftCard\GiftCardSeries');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}