<?php
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getTemplatesByParams(array $params)
 * @method listByParams(array $params)
 * @method infoByParams(array $params)
 */
class ProductCardTemplate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * todo 移除action_scope
     *
     * @param  string $name 优惠名称 [ require true ]
     * @param  array $limit 优惠规则 [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @param  bool $action_scope 升级体验-参数作废 [ require false ]
     * @param  int $create_by 创建人 [ require true ]
     * @param  array $extend 拓展信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, string $apply_in, array $limit, int $create_by, bool $action_scope = false, array $extend = []) {
        return self::getClass()->create([
            "name" => $name,
            "apply_in" => $apply_in,
            "limit" => $limit,
            "create_by" => $create_by,
            "action_scope" => $action_scope,
            "extend" => $extend,
        ]);
    }

    /**
     * 更新模板
     *
     * @param  int $id 模板id [ require true ]
     * @support  string $name 优惠名称 [ require false ]
     * @support  array $limit 优惠限制 [ require false ]
     * @support  array $extend 拓展信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 模板列表-分页
     *
     * @support  array $ids 模板ids [ require false ]
     * @support  string $name 模板名称 [ require false ]
     * @support  string $apply_in 应用于 [ require false ]
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 应用于 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTemplates (int $page, int $page_size) {
        return self::getClass()->getTemplates([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 模板列表
     *
     * @support  array $ids 模板ids [ require false ]
     * @support  string $name 模板名称 [ require false ]
     * @support  string $apply_in 应用于 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 模板详情
     *
     * @param  int $id 模板id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function info (int $id) {
        return self::getClass()->info([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Coupon\ProductCardTemplate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Coupon\ProductCardTemplate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}