<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getTemplatesByParams(array|\Mainto\Bridge\Structs\Preferential\Coupon\Cmd\CouponTemplateListCmd $params)
 */
class CouponTemplateV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 模板列表-分页
     *
     * @var  \Mainto\Bridge\Structs\Preferential\Coupon\Cmd\CouponTemplateListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Preferential\Coupon\DTO\CouponTemplateListDTO
     */
    public static function getTemplates (\Mainto\Bridge\Structs\Preferential\Coupon\Cmd\CouponTemplateListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getTemplates($cmd),
            "\Mainto\Bridge\Structs\Preferential\Coupon\DTO\CouponTemplateListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'CouponTemplateV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'CouponTemplateV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}