<?php
namespace Mainto\Bridge\Enums\Preferential;

class GiftCardStatusEnum {
    /**
     * 未激活
     */
    const INACTIVATED = 'inactivated';
    /**
     * 已激活【已激活可能还未绑定】
     */
    const ACTIVATED = 'activated';
    /**
     * 使用
     */
    const USED = 'used';
    /**
     * 已作废
     */
    const ABOLISHED = 'abolished';
    /**
     * 已过期
     */
    const EXPIRED = 'expired';
    /**
     * 领取到微信卡包
     */
    const IN_WX_CARD = 'wx_card';
    /**
     * 支持延期的状态
     */
    const SUPPORT_DELAY_STATUS = [0 => 'used',1 => 'activated',2 => 'inactivated',3 => 'expired'];
    /**
     * 支持作废的状态
     */
    const SUPPORT_ABOLISH_STATUS = [0 => 'used',1 => 'activated',2 => 'inactivated'];
    /**
     * 全部礼品卡状态
     */
    const All = [0 => 'inactivated',1 => 'activated',2 => 'used',3 => 'abolished',4 => 'expired',5 => 'wx_card'];
    /**
     * 支持过期券码
     */
    const SUPPORT_EXPIRED_STATUS = [0 => 'activated',1 => 'wx_card',2 => 'inactivated'];
}