<?php
namespace Mainto\Bridge\Invokes\Preferential\PreferentialChannel;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getChannelsByParams(array $params)
 */
class PreferentialChannel {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取全部渠道
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Preferential\PreferentialChannel\DTO\ChannelListDTO
     */
    public static function getChannels () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getChannels(),
            "\Mainto\Bridge\Structs\Preferential\PreferentialChannel\DTO\ChannelListDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'PreferentialChannel\PreferentialChannel');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'PreferentialChannel\PreferentialChannel');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}