<?php
namespace Mainto\Bridge\Invokes\Preferential\ProductCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bulkGenerateCardsByParams(array|\Mainto\Bridge\Structs\Preferential\ProductCard\Cmd\ProductCardCreateCmd $params)
 * @method templateStatisticByParams(array $params)
 */
class ProductCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建券码
     *
     * @var  \Mainto\Bridge\Structs\Preferential\ProductCard\Cmd\ProductCardCreateCmd $cmd
     * @throws  \Exception
     * @return  int
     */
    public static function bulkGenerateCards (\Mainto\Bridge\Structs\Preferential\ProductCard\Cmd\ProductCardCreateCmd $cmd) {
        return self::getClass()->bulkGenerateCards($cmd);
    }


    /**
     * 统计模板数量
     *
     * @param  array $templateIds 模板ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function templateStatistic (array $templateIds) {
        return self::getClass()->templateStatistic([
            "templateIds" => $templateIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'ProductCard\ProductCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'ProductCard\ProductCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}