<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createVirtualCardOrderByParams(array|\Mainto\Bridge\Structs\Preferential\GiftCard\Cmd\VirtualOrderCreateCmd $params)
 * @method createPhysicalCardOrderByParams(array|\Mainto\Bridge\Structs\Preferential\GiftCard\Cmd\PhysicalOrderCreateCmd $params)
 */
class GiftCardOrderV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建虚拟卡订单
     *
     * @var  \Mainto\Bridge\Structs\Preferential\GiftCard\Cmd\VirtualOrderCreateCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function createVirtualCardOrder (\Mainto\Bridge\Structs\Preferential\GiftCard\Cmd\VirtualOrderCreateCmd $cmd) {
        return self::getClass()->createVirtualCardOrder($cmd);
    }


    /**
     * 创建实体礼品卡订单
     *
     * @var  \Mainto\Bridge\Structs\Preferential\GiftCard\Cmd\PhysicalOrderCreateCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPhysicalCardOrder (\Mainto\Bridge\Structs\Preferential\GiftCard\Cmd\PhysicalOrderCreateCmd $cmd) {
        return self::getClass()->createPhysicalCardOrder($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'GiftCardOrderV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'GiftCardOrderV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}