<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method chargeByParams(array $params)
 * @method generateUserCardByParams(array|\Mainto\Bridge\Structs\Preferential\GiftCard\Cmd\CreateUserCardCmd $params)
 */
class GiftCardV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 充值礼品卡
     *
     * @param  string $code 券码code [ require true ]
     * @param  int $userId 用户ID [ require true ]
     * @param  float $money 金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function charge (string $code, int $userId, float $money) {
        return self::getClass()->charge([
            "code" => $code,
            "userId" => $userId,
            "money" => $money,
        ]);
    }

    /**
     * 生成礼品卡-绑定用户
     *
     * @var  \Mainto\Bridge\Structs\Preferential\GiftCard\Cmd\CreateUserCardCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function generateUserCard (\Mainto\Bridge\Structs\Preferential\GiftCard\Cmd\CreateUserCardCmd $cmd) {
        return self::getClass()->generateUserCard($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'GiftCardV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'GiftCardV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}