<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allocateByParams(array $params)
 * @method getStocksByParams(array $params)
 * @method getStockProductsByParams(array $params)
 * @method infoByParams(array $params)
 * @method stockLockByParams(array $params)
 * @method releaseStockLockByParams(array $params)
 */
class Stock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 调配
     *
     * @support  string $type 卡类型 require false
     * @support  array $detail 详情 require false
     * @support  int $operator 操作人 [ require true ]
     * @support  int $stockStoreId 库存地 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allocate () {
        return self::getClass()->allocate();
    }

    /**
     * 查询【分页】
     *
     * @support  int $operate_id 封面|产品id require false
     * @support  int $store_id 门店id require false
     * @support  bool $with_cover_info 获取卡封面信息 require false
     * @support  string $type 类型 require false
     * @support  bool $filter_zero_stock 过滤零库存数据 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页显示的数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStocks (int $page = 1, int $page_size = 10) {
        return self::getClass()->getStocks([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取库存记录列表
     *
     * @support  array $stock_ids 库存ids require false
     * @support  string $type 类型 require false
     * @support  string $status 库存状态 require false
     * @support  array $card_ids 卡ids require false
     * @support  int $store_id 门店ID require false
     * @support  bool $with_card_info 获取卡信息 require false
     * @support  int $stock_operate_id 库存operate_id（产品卡：产品卡模板ID，礼品卡：礼品卡封面ID require false
     * @support  int $stock_money 礼品卡库存的金额（该查询条件仅适用于礼品卡库存。礼品卡的库存记录里有金额，礼品卡以封面ID和面值区别库存记录） require false
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStockProducts (int $page = 1, int $page_size = 10) {
        return self::getClass()->getStockProducts([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取库存记录详情
     *
     * @support  int $id 库存id require false
     * @support  string $type 类型 require false
     * @support  bool $with_card_info 获取卡信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * 锁定库存
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  array $cardIds 卡ID [ require true ]
     * @support  string $type 卡类型[礼品卡|产品卡] require false
     * @support  int $operator 操作人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function stockLock () {
        return self::getClass()->stockLock();
    }

    /**
     * 释放锁定库存
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  array $cardIds 卡ID [ require true ]
     * @support  string $type 卡类型[礼品卡|产品卡] require false
     * @support  int $operator 操作人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function releaseStockLock () {
        return self::getClass()->releaseStockLock();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Stock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Stock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}