<?php
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method prepaidCreateByParams(array $params)
 * @method afterPayByParams(array $params)
 * @method getOrdersByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getOrderByOrderNumByParams(array $params)
 * @method updateInvoiceIdByParams(array $params)
 * @method changePayTypeByParams(array $params)
 */
class ProductCardOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品卡订单【包含库存移除|创建卡】
     *
     * @support  string $sex 性别 [ require false ]
     * @param  string $type 卡类型 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  int $user_id 用户id [ require true ]
     * @support  string $pay_type 支付方式 [ require false ]
     * @support  array $card_ids 卡IDs [ require false ]
     * @support  int $store_id 门店id [ require true ]
     * @support  int $create_by 创建人 [ require true ]
     * @support  string $user_name 用户名 [ require true ]
     * @support  float $ori_money 原价金额 [ require true ]
     * @support  float $pay_money 实付金额 [ require true ]
     * @support  string $buy_channel 购买渠道 [ require false ]
     * @support  int $sale_store_id 售卖门店 [ require false ]
     * @support  array $extend 拓展信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $type) {
        return self::getClass()->create([
            "type" => $type,
        ]);
    }

    /**
     * 创建产品卡订单【未支付订单】
     *
     * @support  string $sex 性别 [ require false ]
     * @support  string $phone 手机号 [ require true ]
     * @support  int $user_id 用户id [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @support  int $create_by 创建人 [ require true ]
     * @support  string $user_name 用户名 [ require true ]
     * @support  float $ori_money 原价金额 [ require true ]
     * @support  float $pay_money 实付金额 [ require true ]
     * @support  string $buy_channel 购买渠道 [ require false ]
     * @support  mixed $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function prepaidCreate () {
        return self::getClass()->prepaidCreate([
        ]);
    }

    /**
     * 产品卡订单支付
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $pay_type 支付类型 [ require true ]
     * @param  string $payment_no 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function afterPay (int $order_id, string $pay_type, string $payment_no) {
        return self::getClass()->afterPay([
            "order_id" => $order_id,
            "pay_type" => $pay_type,
            "payment_no" => $payment_no,
        ]);
    }

    /**
     * 获取列表
     *
     * @support  string $type 订单类型 [ require false ]
     * @support  string $phone 手机号 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $store_id 门店ID【包含store_id+sale_store_id】 [ require false ]
     * @support  string $pay_type 订单支付类型 [ require false ]
     * @support  string $user_name 用户姓名 [ require false ]
     * @support  array $order_nums 订单号 [ require false ]
     * @support  string $create_end_at 结束时间 [ require false ]
     * @support  string $create_start_at 开始时间 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrders (int $page = 1, int $page_size = 10) {
        return self::getClass()->getOrders([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取详情
     *
     * @param  int $id 产品卡id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (int $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * 通过订单号获取订单
     *
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderByOrderNum (string $order_num) {
        return self::getClass()->getOrderByOrderNum([
            "order_num" => $order_num,
        ]);
    }

    /**
     * 修改发票信息
     *
     * @param  int $invoice_id 发票id [ require true ]
     * @param  array $order_nums 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateInvoiceId (array $order_nums, int $invoice_id) {
        return self::getClass()->updateInvoiceId([
            "order_nums" => $order_nums,
            "invoice_id" => $invoice_id,
        ]);
    }

    /**
     * 修改支付方式
     *
     * @param  int $id 订单id [ require true ]
     * @support  string $pay_type 支付方式 [ require true ]
     * @support  string $payment_no 支付流水号 [ require false ]
     * @support  array $extend 扩展信息[操作人信息] [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePayType (int $id) {
        return self::getClass()->changePayType([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Coupon\ProductCardOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Coupon\ProductCardOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}