<?php
namespace Mainto\Bridge\Enums\Preferential;

class GiftCardOrderPayTypeEnum {
    const POS = 'pos';
    const CASH = 'cash';
    const WECHAT = 'wechat';
    const NO_PAY = 'no_pay';
    const ALIPAY = 'alipay';
    const ENTERPRISE = 'enterprise';
    const ICBC_WECHAT = 'icbc_wechat';
    const OFFLINE_ALIPAY = 'offline_alipay';
    const OFFLINE_WECHAT = 'offline_wechat';
    const PAYMAX_WECHAT = 'paymax_wechat';
    const PAYMAX_ALIPAY = 'paymax_alipay';
    const PAYMAX_WX_APP = 'paymax_wx_app';
    /**
     * 线上支付枚举值
     */
    const ONLINE_PAY_MAP = [0 => 'wechat',1 => 'alipay',2 => 'icbc_wechat',3 => 'paymax_wechat',4 => 'paymax_alipay',5 => 'paymax_wx_app'];
    /**
     * 线下支付枚举值
     */
    const OFFLINE_PAY_MAP = [0 => 'pos',1 => 'cash',2 => 'enterprise',3 => 'offline_alipay',4 => 'offline_wechat'];
}