<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updateExpireGiftCardsByParams(array $params)
 * @method updateExpireCouponsByParams(array $params)
 * @method updateExpireProductCardsByParams(array $params)
 * @method updateExpireInteriorByParams(array $params)
 * @method abolishCouponsByParams(array $params)
 * @method convertUserInfoByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更新过期礼品卡
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateExpireGiftCards () {
        return self::getClass()->updateExpireGiftCards();
    }

    /**
     * 更新过期优惠券
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateExpireCoupons () {
        return self::getClass()->updateExpireCoupons();
    }

    /**
     * 更新过期礼品卡
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateExpireProductCards () {
        return self::getClass()->updateExpireProductCards();
    }

    /**
     * 更新过期内部折扣码
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateExpireInterior () {
        return self::getClass()->updateExpireInterior();
    }

    /**
     * 作废优惠券[OA定时任务调用]
     *
     * @param  array $codes 券codes [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function abolishCoupons (array $codes) {
        return self::getClass()->abolishCoupons([
            "codes" => $codes,
        ]);
    }

    /**
     * 更新券用户信息
     *
     * @support  int $user_id 用户ID [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function convertUserInfo () {
        return self::getClass()->convertUserInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}