<?php
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByParams(array $params)
 * @method getListByPageByParams(array $params)
 */
class GiftCardTopic {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @support  string $title 主题标题 [ require true ]
     * @support  string $img_path 主题封面图 [ require true ]
     * @support  int $sequence 排序值 require false
     * @support  int $series_id 系列id require false
     * @support  array $extend 拓展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新
     *
     * @param  int $id id [ require true ]
     * @support  string $img_path 主题封面图 require false
     * @support  int $series_id 系列id require false
     * @support  string $title 标题 require false
     * @support  int $sequence 排序值 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 获取详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (int $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * 获取列表
     *
     * @support  array $series_ids 系列ids require false
     * @support  string $title 标题 require false
     * @support  bool $has_series_info 是否包含系列信息 require false
     * @support  bool $has_covers_info 是否包含卡面信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 获取列表-分页
     *
     * @support  array $series_ids 系列ids require false
     * @support  string $title 标题 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @support  bool $has_series_info 是否包含系列信息 require false
     * @support  bool $has_covers_info 是否包含卡面信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListByPage (int $page = 1, int $page_size = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'GiftCard\GiftCardTopic');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'GiftCard\GiftCardTopic');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}