<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2026-01-31 14:52:07
 */
namespace Mainto\Bridge\Structs\Preferential\ProductCard\Cmd;

class TimesCardOrderCreateCmd {
    /**
     * @var  int
     * 用户ID
     * validation: 
     */
    public int $userId;
    /**
     * @var  string
     * 用户名
     * validation: 
     */
    public string $userName;
    /**
     * @var  string
     * 手机号
     * validation: 
     */
    public string $phone;
    /**
     * @var  string
     * 用户性别
     * validation: in:female,male,unknown
     */
    public string $sex = "unknown";
    /**
     * @var  int
     * 渠道ID
     * validation: 
     */
    public int $channelId;
    /**
     * @var  null|int
     * 门店ID
     * validation: 
     */
    public ?int $storeId = null;
    /**
     * @var  int
     * 创建人
     * validation: 
     */
    public int $createBy;
    /**
     * @var  float
     * 订单金额(原价)
     * validation: min:0
     */
    public float $oriMoney;
    /**
     * @var  float
     * 实付金额
     * validation: min:0|lte:oriMoney
     */
    public float $payMoney;
    /**
     * @var  \Mainto\Bridge\Structs\Preferential\ProductCard\Cmd\TimesCardPurchaseItemCmd[]
     * 购买明细列表
     * validation: 
     */
    public array $purchaseItems = [];
    /**
     * @var  null|array
     * 扩展信息
     * validation: 
     */
    public ?array $extend = null;

    public function __construct (int $userId = 0, string $userName = '', string $phone = '', int $channelId = 0, int $createBy = 0, float $oriMoney = 0.0, float $payMoney = 0.0) {
        if (!is_null($userId)) {
            $this->userId = $userId;
        }
        if (!is_null($userName)) {
            $this->userName = $userName;
        }
        if (!is_null($phone)) {
            $this->phone = $phone;
        }
        if (!is_null($channelId)) {
            $this->channelId = $channelId;
        }
        if (!is_null($createBy)) {
            $this->createBy = $createBy;
        }
        if (!is_null($oriMoney)) {
            $this->oriMoney = $oriMoney;
        }
        if (!is_null($payMoney)) {
            $this->payMoney = $payMoney;
        }
    }

    public static function create(int $userId = 0, string $userName = '', string $phone = '', int $channelId = 0, int $createBy = 0, float $oriMoney = 0.0, float $payMoney = 0.0): self {
        return new self($userId, $userName, $phone, $channelId, $createBy, $oriMoney, $payMoney);
    }

    public function setUserId(int $userId): self {
        $this->userId = $userId;

        return $this;
    }

    public function setUserName(string $userName): self {
        $this->userName = $userName;

        return $this;
    }

    public function setPhone(string $phone): self {
        $this->phone = $phone;

        return $this;
    }

    public function setSex(string $sex): self {
        $this->sex = $sex;

        return $this;
    }

    public function setChannelId(int $channelId): self {
        $this->channelId = $channelId;

        return $this;
    }

    public function setStoreId(?int $storeId): self {
        $this->storeId = $storeId;

        return $this;
    }

    public function setCreateBy(int $createBy): self {
        $this->createBy = $createBy;

        return $this;
    }

    public function setOriMoney(float $oriMoney): self {
        $this->oriMoney = $oriMoney;

        return $this;
    }

    public function setPayMoney(float $payMoney): self {
        $this->payMoney = $payMoney;

        return $this;
    }

    public function setPurchaseItems(array $purchaseItems): self {
        $this->purchaseItems = $purchaseItems;

        return $this;
    }

    public function setExtend(?array $extend): self {
        $this->extend = $extend;

        return $this;
    }
}