<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2026-01-28 15:01:08
 */
namespace Mainto\Bridge\Structs\Preferential\ProductCard\Cmd;

class TimesCardRefundCreateCmd {
    /**
     * @var  int
     * 订单ID
     * validation: required|integer
     */
    public int $orderId;
    /**
     * @var  float
     * 退款金额
     * validation: required|numeric|min:0.01
     */
    public float $money;
    /**
     * @var  string
     * 退款方式: auto-自动退款, hand-手动退款
     * validation: required|in:auto,hand
     */
    public string $refundMethod = "hand";
    /**
     * @var  null|string
     * 退款人姓名（手动退款时必填）
     * validation: nullable|string|max:50
     */
    public ?string $alipayName = null;
    /**
     * @var  null|string
     * 退款账户（手动退款时必填）
     * validation: nullable|string|max:100
     */
    public ?string $alipayAccount = null;
    /**
     * @var  string
     * 退款原因
     * validation: required|string|max:255
     */
    public string $reason;
    /**
     * @var  int
     * 录入人伙伴ID
     * validation: required|integer
     */
    public int $inputStaffId;
    /**
     * @var  bool
     * 是否快速退款
     * validation: boolean
     */
    public bool $isFastRefund = false;

    public function __construct (int $orderId = 0, float $money = 0.0, string $reason = '', int $inputStaffId = 0) {
        if (!is_null($orderId)) {
            $this->orderId = $orderId;
        }
        if (!is_null($money)) {
            $this->money = $money;
        }
        if (!is_null($reason)) {
            $this->reason = $reason;
        }
        if (!is_null($inputStaffId)) {
            $this->inputStaffId = $inputStaffId;
        }
    }

    public static function create(int $orderId = 0, float $money = 0.0, string $reason = '', int $inputStaffId = 0): self {
        return new self($orderId, $money, $reason, $inputStaffId);
    }

    public function setOrderId(int $orderId): self {
        $this->orderId = $orderId;

        return $this;
    }

    public function setMoney(float $money): self {
        $this->money = $money;

        return $this;
    }

    public function setRefundMethod(string $refundMethod): self {
        $this->refundMethod = $refundMethod;

        return $this;
    }

    public function setAlipayName(?string $alipayName): self {
        $this->alipayName = $alipayName;

        return $this;
    }

    public function setAlipayAccount(?string $alipayAccount): self {
        $this->alipayAccount = $alipayAccount;

        return $this;
    }

    public function setReason(string $reason): self {
        $this->reason = $reason;

        return $this;
    }

    public function setInputStaffId(int $inputStaffId): self {
        $this->inputStaffId = $inputStaffId;

        return $this;
    }

    public function setIsFastRefund(bool $isFastRefund): self {
        $this->isFastRefund = $isFastRefund;

        return $this;
    }
}