<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2026-01-28 15:11:55
 */
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ProductCardOrderV2
 * @method createVirtualCardOrderByParams(array $params) 创建虚拟卡订单
 * @method createVirtualCardOrderReturnNumByParams(array $params) 创建虚拟卡订单(返回订单号)
 * @method createPhysicalCardOrderByParams(array $params) 创建实体卡订单
 * @method afterPayByParams(array $params) 虚拟卡订单支付后修改信息
 * @method createTimesCardOrderByParams(array $params) 创建次卡订单
 * @method getTimesCardOrderListByParams(array $params) 次卡订单列表
 * @method getTimesCardOrderDetailByParams(array $params) 次卡订单详情
 * @method getTimesCardOrderDetailByOrderNumByParams(array $params) 通过订单号获取次卡订单详情
 * @method timesCardOrderAfterPayByParams(array $params) 次卡订单支付后处理
 * @method cancelTimesCardOrderByParams(array $params) 取消次卡订单
 * @method createAndPassTimesCardRefundByParams(array $params) 次卡退款并自动通过
 * @method createTimesCardRefundByParams(array $params) 创建次卡退款申请
 * @method passTimesCardRefundByParams(array $params) 手动通过次卡退款
 * @method rejectTimesCardRefundByParams(array $params) 手动拒绝次卡退款
 * @method getTimesCardRefundListByParams(array $params) 次卡退款处理列表
 * @method getTimesCardRefundDetailByParams(array $params) 次卡退款详情
 */
class ProductCardOrderV2 {
    private static string $serviceName = "Preferential";

    private static string $className = "ProductCardOrderV2";

    /**
     * 创建虚拟卡订单
     * @return  int
    */
    public static function createVirtualCardOrder (\Mainto\Bridge\Structs\Preferential\ProductCard\Cmd\OrderCreateForVirtualCardCmd $orderCreateForVirtualCardCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createVirtualCardOrder($orderCreateForVirtualCardCmd);
    }

    /**
     * 创建虚拟卡订单(返回订单号)
     * @return  string
    */
    public static function createVirtualCardOrderReturnNum (\Mainto\Bridge\Structs\Preferential\ProductCard\Cmd\OrderCreateForVirtualCardCmd $orderCreateForVirtualCardCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createVirtualCardOrderReturnNum($orderCreateForVirtualCardCmd);
    }

    /**
     * 创建实体卡订单
     * @return  int
    */
    public static function createPhysicalCardOrder (\Mainto\Bridge\Structs\Preferential\ProductCard\Cmd\OrderCreateForPhysicalCardCmd $orderCreateForPhysicalCardCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPhysicalCardOrder($orderCreateForPhysicalCardCmd);
    }

    /**
     * 虚拟卡订单支付后修改信息
     * @return  int
    */
    public static function afterPay (\Mainto\Bridge\Structs\Preferential\ProductCard\Cmd\OrderUpdateForVirtualCardCmd $orderUpdateForVirtualCardCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterPay($orderUpdateForVirtualCardCmd);
    }

    /**
     * 创建次卡订单
     * @return  array
    */
    public static function createTimesCardOrder (\Mainto\Bridge\Structs\Preferential\ProductCard\Cmd\TimesCardOrderCreateCmd $timesCardOrderCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createTimesCardOrder($timesCardOrderCreateCmd);
    }

    /**
     * 次卡订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getTimesCardOrderList (int $page = 1, int $page_size = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTimesCardOrderList(["page" => $page, "page_size" => $page_size]);
    }

    /**
     * 次卡订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getTimesCardOrderDetail (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTimesCardOrderDetail(["order_id" => $order_id]);
    }

    /**
     * 通过订单号获取次卡订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getTimesCardOrderDetailByOrderNum (string $order_num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTimesCardOrderDetailByOrderNum(["order_num" => $order_num]);
    }

    /**
     * 次卡订单支付后处理
     * @return  array
    */
    public static function timesCardOrderAfterPay (\Mainto\Bridge\Structs\Preferential\ProductCard\Cmd\TimesCardOrderAfterPayCmd $timesCardOrderAfterPayCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->timesCardOrderAfterPay($timesCardOrderAfterPayCmd);
    }

    /**
     * 取消次卡订单
     * @return  array
    */
    public static function cancelTimesCardOrder (\Mainto\Bridge\Structs\Preferential\ProductCard\Cmd\TimesCardOrderCancelCmd $timesCardOrderCancelCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelTimesCardOrder($timesCardOrderCancelCmd);
    }

    /**
     * 次卡退款并自动通过
     * @return  array
    */
    public static function createAndPassTimesCardRefund (\Mainto\Bridge\Structs\Preferential\ProductCard\Cmd\TimesCardRefundCreateCmd $timesCardRefundCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createAndPassTimesCardRefund($timesCardRefundCreateCmd);
    }

    /**
     * 创建次卡退款申请
     * @return  array
    */
    public static function createTimesCardRefund (\Mainto\Bridge\Structs\Preferential\ProductCard\Cmd\TimesCardRefundCreateCmd $timesCardRefundCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createTimesCardRefund($timesCardRefundCreateCmd);
    }

    /**
     * 手动通过次卡退款
     * @return  array
    */
    public static function passTimesCardRefund (\Mainto\Bridge\Structs\Preferential\ProductCard\Cmd\TimesCardRefundPassCmd $timesCardRefundPassCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->passTimesCardRefund($timesCardRefundPassCmd);
    }

    /**
     * 手动拒绝次卡退款
     * @return  array
    */
    public static function rejectTimesCardRefund (\Mainto\Bridge\Structs\Preferential\ProductCard\Cmd\TimesCardRefundRejectCmd $timesCardRefundRejectCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->rejectTimesCardRefund($timesCardRefundRejectCmd);
    }

    /**
     * 次卡退款处理列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getTimesCardRefundList (int $page = 1, int $page_size = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTimesCardRefundList(["page" => $page, "page_size" => $page_size]);
    }

    /**
     * 次卡退款详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getTimesCardRefundDetail (int $refund_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTimesCardRefundDetail(["refund_id" => $refund_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}