<?php
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method managerCreateByParams(array $params)
 * @method userCreateByParams(array $params)
 * @method afterPayByParams(array $params)
 * @method prepaidCreateByParams(array $params)
 * @method getPayTypesByParams(array $params)
 * @method getListByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getInfoByNoByParams(array $params)
 * @method updateInvoiceIdByParams(array $params)
 * @method changePayTypeByParams(array $params)
 */
class GiftCardOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 管理端售卖礼品卡
     *
     * @support  string $sex 性别 require false
     * @param  string $type 卡类型 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  uint $user_id 用户id [ require true ]
     * @support  array<uint> $card_ids 卡片ids require false
     * @support  string $pay_type 支付方式 require false
     * @support  uint $store_id 门店id [ require true ]
     * @support  string $user_name 用户名 [ require true ]
     * @support  double $ori_money 原始金额 [ require true ]
     * @support  double $pay_money 实付 [ require true ]
     * @support  uint $create_by 录单人 [ require true ]
     * @support  string $buy_channel 购买渠道 require false
     * @support  uint $sale_store_id 售卖门店ID require false
     * @support  array $extend 拓展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function managerCreate (string $type) {
        return self::getClass()->managerCreate([
            "type" => $type,
        ]);
    }

    /**
     * 用户购买礼品卡【线上】
     *
     * @support  string $phone 手机号 [ require true ]
     * @support  array $extend 拓展信息 require false
     * @support  uint $user_id 用户id [ require true ]
     * @support  string $user_name 用户名 require false
     * @param  double $pay_money 实付 [ require true ]
     * @param  array $card_item 卡片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function userCreate (float $pay_money, array $card_item) {
        return self::getClass()->userCreate([
            "pay_money" => $pay_money,
            "card_item" => $card_item,
        ]);
    }

    /**
     * 礼品卡订单支付【线上支付|线下拉卡拉支付】
     *
     * @param  uint $order_id 订单id [ require true ]
     * @param  string $pay_type 支付类型 [ require true ]
     * @param  string $payment_no 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function afterPay (int $order_id, string $pay_type, string $payment_no) {
        return self::getClass()->afterPay([
            "order_id" => $order_id,
            "pay_type" => $pay_type,
            "payment_no" => $payment_no,
        ]);
    }

    /**
     * 创建礼品卡订单【未支付订单】- 线上
     *
     * @support  string $sex 性别 require false
     * @support  string $phone 手机号 [ require true ]
     * @support  uint $user_id 用户id [ require true ]
     * @support  uint $store_id 门店id [ require true ]
     * @support  uint $create_by 创建人 [ require true ]
     * @support  string $user_name 用户名 [ require true ]
     * @support  unsignedDouble $ori_money 原价金额 [ require true ]
     * @support  unsignedDouble $pay_money 实付金额 [ require true ]
     * @support  string $buy_channel 购买渠道 require false
     * @support  App\Rpc\Controllers\GiftCard\GiftCardOrderController\PrepaidCreateParamsExtend $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function prepaidCreate () {
        return self::getClass()->prepaidCreate();
    }

    /**
     * 礼品卡订单支付类型
     * @deprecated
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPayTypes () {
        return self::getClass()->getPayTypes();
    }

    /**
     * 获取列表
     *
     * @support  string $order_num 订单号 require false
     * @support  array $order_nums 订单号 require false
     * @support  uint $store_id 门店id require false
     * @support  uint $user_id 用户id require false
     * @support  string $type 订单类型 require false
     * @support  bool $with_items 是否需要明细信息 require false
     * @support  array $card_ids 卡ids require false
     * @support  string $status 支付状态 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 获取列表-分页
     *
     * @support  uint $store_id 门店ID【包含store_id+sale_store_id】 require false
     * @support  uint $user_id 用户id require false
     * @support  string $user_name 用户名 require false
     * @support  array $order_nums 订单号 require false
     * @support  string $phone 手机号 require false
     * @support  string $type 订单类型 require false
     * @support  string $start_at 支付开始时间 require false
     * @support  string $end_at 支付结束时间 require false
     * @support  string $pay_type 支付类型 require false
     * @support  string $status 支付状态 require false
     * @support  bool $with_items 是否需要明细信息 require false
     * @param  uint $page 页码 [ require true ]
     * @param  uint $page_size 页码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListByPage (int $page = 1, int $page_size = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取详情
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (int $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * 根据订单号获取详情
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfoByNo (string $order_no) {
        return self::getClass()->getInfoByNo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 修改发票信息
     *
     * @param  uint $invoice_id 发票id [ require true ]
     * @param  array $order_nums 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateInvoiceId (array $order_nums, int $invoice_id) {
        return self::getClass()->updateInvoiceId([
            "order_nums" => $order_nums,
            "invoice_id" => $invoice_id,
        ]);
    }

    /**
     * 修改支付方式
     *
     * @param  int $id 订单id [ require true ]
     * @support  string $pay_type 支付方式 [ require true ]
     * @support  string $payment_no 支付流水号 require false
     * @support  array $extend 扩展信息[操作人信息] require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePayType (int $id) {
        return self::getClass()->changePayType([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'GiftCard\GiftCardOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'GiftCard\GiftCardOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}