<?php
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getLogsByParams(array $params)
 * @method listByParams(array $params)
 */
class CouponCreateLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取列表[分页]
     *
     * @support  array<int> $ids 记录ids require false
     * @support  int $channel 渠道号 require false
     * @support  array<uint> $channels 渠道号s require false
     * @support  string $apply_in 应用于 require false
     * @support  string $type 模板类型 require false
     * @support  string $created_at_end 创建时间止 require false
     * @support  string $created_at_start 创建时间起 require false
     * @support  bool $with_template_info 包含模板息 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLogs (int $page = 1, int $page_size = 10) {
        return self::getClass()->getLogs([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取列表
     *
     * @support  array<int> $ids 记录ids require false
     * @support  uint $channel 渠道号 require false
     * @support  array<uint> $channels 渠道号s require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Coupon\CouponCreateLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Coupon\CouponCreateLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}