<?php
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method generateBatchCouponsByParams(array $params)
 * @method bulkGenerateCouponsByParams(array $params)
 * @method generateActivityCouponByParams(array $params)
 * @method bulkGenerateActivityCouponByParams(array $params)
 * @method generateMemberCouponsByParams(array $params)
 * @method listByParams(array $params)
 * @method getCouponsByParams(array $params)
 * @method infoByParams(array $params)
 * @method delayByParams(array $params)
 * @method updateTransferInfoByParams(array $params)
 * @method getUserCouponsByParams(array $params)
 * @method markUserCouponsByParams(array $params)
 * @method useByParams(array $params)
 * @method getCouponDiscountPriceByParams(array $params)
 * @method getSpecialCouponDiscountByParams(array $params)
 * @method bindByParams(array $params)
 * @method refundByParams(array $params)
 * @method abolishCouponsByParams(array $params)
 * @method statisticCouponsByParams(array $params)
 * @method statisticCouponsByLogIdsByParams(array $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量生成优惠券
     *
     * @support  uint $count 创建数量 require false
     * @support  string $title 标题 [ require true ]
     * @support  uint $user_id 用户ID require false
     * @support  string $status 状态 require false
     * @support  double $discount 折扣 require false
     * @support  unsignedDouble $ori_money 原金额 require false
     * @support  unsignedDouble $pay_money 收金额 require false
     * @support  uint $create_by 创建人 require false
     * @support  string $stop_usage 结束使用时间 require false
     * @support  uint $template_id 模板id [ require true ]
     * @support  string $buy_channel 购买渠道 require false
     * @support  string $start_usage 开始使用时间 require false
     * @support  uint $sale_store_id 门店id require false
     * @support  array $extend 拓展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function generateBatchCoupons () {
        return self::getClass()->generateBatchCoupons();
    }

    /**
     * 批量生成优惠券
     *
     * @support  uint $count 创建数量 require false
     * @support  string $title 标题 [ require true ]
     * @support  string $status 状态 require false
     * @support  uint $channel 渠道号 require false
     * @support  uint $userId 用户ID require false
     * @support  double $discount 折扣 require false
     * @support  unsignedDouble $oriMoney 原金额 require false
     * @support  unsignedDouble $payMoney 收金额 require false
     * @support  uint $createBy 创建人 require false
     * @support  string $stopUsage 结束使用时间 require false
     * @support  uint $templateId 模板id [ require true ]
     * @support  string $buyChannel 购买渠道 require false
     * @support  string $startUsage 开始使用时间 require false
     * @support  uint $saleStoreId 门店id require false
     * @support  array $extend 拓展信息 require false
     * @support  array $logUniqueByFields 记录唯一 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function bulkGenerateCoupons () {
        return self::getClass()->bulkGenerateCoupons();
    }

    /**
     * 活动页生成优惠券
     * @deprecated
     *
     * @support  string $title 标题 require false
     * @support  string $status 状态 require false
     * @support  int $user_id 用户id require false
     * @param  uint $channel 渠道号 [ require true ]
     * @support  double $discount 折扣 require false
     * @support  unsignedDouble $ori_money 原金额 require false
     * @support  unsignedDouble $pay_money 支付金额 require false
     * @support  string $stop_usage 结束使用时间 require false
     * @support  string $start_usage 开始使用时间 require false
     * @param  uint $template_id 模板id [ require true ]
     * @support  array $extend 拓展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function generateActivityCoupon (int $channel, int $template_id) {
        return self::getClass()->generateActivityCoupon([
            "channel" => $channel,
            "template_id" => $template_id,
        ]);
    }

    /**
     * 批量生成券【多用户绑定】
     *
     * @support  array $phones 手机号 require false
     * @support  array $user_ids 用户ids require false
     * @support  string $title 标题 require false
     * @support  string $status 状态 require false
     * @support  uint $channel 渠道号 require false
     * @support  double $discount 折扣 require false
     * @support  uint $create_by 创建人 require false
     * @support  unsignedDouble $ori_money 原金额 require false
     * @support  unsignedDouble $pay_money 支付金额 require false
     * @support  string $stop_usage 结束使用时间 require false
     * @support  string $start_usage 开始使用时间 require false
     * @support  uint $template_id 模板id [ require true ]
     * @support  array $extend 拓展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function bulkGenerateActivityCoupon () {
        return self::getClass()->bulkGenerateActivityCoupon();
    }

    /**
     * 生成会员券
     * @deprecated
     *
     * @support  uint $count 生成数量 require false
     * @support  double $discount 折扣 require false
     * @support  uint $user_id 用户id [ require true ]
     * @support  uint $template_id 模板ID [ require true ]
     * @support  string $member_type 会员体系券类型 require false
     * @support  string $stop_usage 结束使用时间 require false
     * @support  string $start_usage 开始使用时间 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function generateMemberCoupons () {
        return self::getClass()->generateMemberCoupons();
    }

    /**
     * 获取列表
     *
     * @support  array $ids 卡ids require false
     * @support  string $type 优惠券类型 require false
     * @support  array $codes 优惠码组 require false
     * @support  string $status 状态 require false
     * @support  uint $user_id 用户id require false
     * @support  uint $channel 渠道号 require false
     * @support  string $apply_in 应用于 require false
     * @support  string $used_at_end 使用时间止 require false
     * @support  array $multi_status 多状态查询 require false
     * @support  string $used_at_start 使用时间起 require false
     * @support  uint $create_log_id 创建记录id require false
     * @support  array $order_ids 外部订单ids require false
     * @support  array $order_diff_ids 外部订单diff-ids require false
     * @support  string $created_at_end 创建时间止 require false
     * @support  string $created_at_start 创建时间起 require false
     * @support  bool $with_template_info 包含模板息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取列表-分页
     *
     * @support  array $ids 卡ids require false
     * @support  array $codes 优惠码组 require false
     * @support  string $status 状态 require false
     * @support  uint $user_id 用户id require false
     * @support  string $apply_in 应用于 require false
     * @support  string $used_at_end 使用时间止 require false
     * @support  array $multi_status 多状态查询 require false
     * @support  uint $create_log_id 创建记录id require false
     * @support  string $used_at_start 使用时间起 require false
     * @support  string $created_at_end 创建时间止 require false
     * @support  string $created_at_start 创建时间起 require false
     * @support  bool $with_template_info 包含类型信息 require false
     * @support  uint $product_group_id 产品组ID require false
     * @support  uint $product_id 产品ID require false
     * @support  uint $store_dimension_id 适用门店维度id require false
     * @support  bool $action_scope 是否可以用于升级服务 require false
     * @support  string $description 描述 require false
     * @support  string $sort_field 排序字段 require false
     * @support  string $sort_direction 排序方向 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCoupons (int $page = 1, int $page_size = 10) {
        return self::getClass()->getCoupons([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取详情
     *
     * @support  uint $id 优惠券id require false
     * @support  string $code 优惠code require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * 优惠券延期
     *
     * @support  array<string> $codes 优惠码 require false
     * @support  string $stop_usage 到期日期 require false
     * @support  uint $operator 操作人-参数作废，计入extend require false
     * @support  array $extend 扩展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function delay () {
        return self::getClass()->delay();
    }

    /**
     * 更新适用订单【转门店】
     *
     * @param  uint $couponId 优惠券id [ require true ]
     * @param  uint $newOrderId 订单id [ require true ]
     * @param  uint $newOrderDiffId 新订单diff-id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateTransferInfo (int $couponId, int $newOrderId, int $newOrderDiffId = null) {
        return self::getClass()->updateTransferInfo([
            "couponId" => $couponId,
            "newOrderId" => $newOrderId,
            "newOrderDiffId" => $newOrderDiffId,
        ]);
    }

    /**
     * 获得用户优惠券
     *
     * @support  uint $user_id 用户id [ require true ]
     * @support  string $status 优惠券状态 require false
     * @support  string $apply_in 应用于 require false
     * @support  bool $with_template_info 获取模板信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserCoupons () {
        return self::getClass()->getUserCoupons();
    }

    /**
     * 标记用户券是否可用
     *
     * @param  uint $user_id 用户id [ require true ]
     * @param  array $products 产品信息 [ require true ]
     * @param  uint $store_id 门店id [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function markUserCoupons (int $user_id, array $products, int $store_id, string $apply_in) {
        return self::getClass()->markUserCoupons([
            "user_id" => $user_id,
            "products" => $products,
            "store_id" => $store_id,
            "apply_in" => $apply_in,
        ]);
    }

    /**
     * 使用优惠券
     *
     * @param  uint $id 优惠券id [ require true ]
     * @support  uint $user_id 用户id [ require true ]
     * @support  uint $order_id 订单ID [ require true ]
     * @support  uint $order_diff_id 订单diff—id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function use (int $id) {
        return self::getClass()->use([
            "id" => $id,
        ]);
    }

    /**
     * 获得优惠券可折扣金额
     *
     * @param  uint $coupon_id 优惠券id [ require true ]
     * @param  array $node_info 节点详情 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCouponDiscountPrice (int $coupon_id, array $node_info) {
        return self::getClass()->getCouponDiscountPrice([
            "coupon_id" => $coupon_id,
            "node_info" => $node_info,
        ]);
    }

    /**
     * 加修加印券和加印券可折扣金额
     *
     * @param  uint $couponId 优惠券ID [ require true ]
     * @param  double $perPrice 商品单价 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSpecialCouponDiscount (int $couponId, float $perPrice) {
        return self::getClass()->getSpecialCouponDiscount([
            "couponId" => $couponId,
            "perPrice" => $perPrice,
        ]);
    }

    /**
     * 绑定优惠券
     *
     * @param  uint $user_id 用户id [ require true ]
     * @param  string $code 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bind (int $user_id, string $code) {
        return self::getClass()->bind([
            "user_id" => $user_id,
            "code" => $code,
        ]);
    }

    /**
     * 退款返回优惠券
     *
     * @param  uint $coupon_id 优惠券id [ require true ]
     * @param  uint $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refund (int $coupon_id, int $user_id) {
        return self::getClass()->refund([
            "coupon_id" => $coupon_id,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 作废优惠券
     *
     * @support  array<uint> $ids 优惠券IDs require false
     * @support  array<string> $codes 优惠码组 require false
     * @support  string $type 作废类型 require false
     * @support  uint $operator 操作人-参数作废，计入extend require false
     * @support  array $extend 扩展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function abolishCoupons () {
        return self::getClass()->abolishCoupons();
    }

    /**
     * 渠道统计
     *
     * @param  uint $channel 渠道号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function statisticCoupons (int $channel) {
        return self::getClass()->statisticCoupons([
            "channel" => $channel,
        ]);
    }

    /**
     * 创建记录统计
     *
     * @param  array<uint> $logIds 渠道号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function statisticCouponsByLogIds (array $logIds) {
        return self::getClass()->statisticCouponsByLogIds([
            "logIds" => $logIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Coupon\Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Coupon\Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}