<?php
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method generateBatchCouponsByParams(array $params)
 * @method bulkGenerateCouponsByParams(array $params)
 * @method generateActivityCouponByParams(array $params)
 * @method bulkGenerateActivityCouponByParams(array $params)
 * @method generateMemberCouponsByParams(array $params)
 * @method listByParams(array $params)
 * @method getCouponsByParams(array $params)
 * @method infoByParams(array $params)
 * @method delayByParams(array $params)
 * @method updateTransferInfoByParams(array $params)
 * @method getUserCouponsByParams(array $params)
 * @method markUserCouponsByParams(array $params)
 * @method useByParams(array $params)
 * @method getCouponDiscountPriceByParams(array $params)
 * @method getSpecialCouponDiscountByParams(array $params)
 * @method bindByParams(array $params)
 * @method refundByParams(array $params)
 * @method abolishCouponsByParams(array $params)
 * @method statisticCouponsByParams(array $params)
 * @method statisticCouponsByLogIdsByParams(array $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量生成优惠券
     *
     * @support  int $count 创建数量 [Original type uint] [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  int $user_id 用户ID [Original type uint] 
     * @support  string $status 状态 
     * @support  float $discount 折扣 [Original type double] [ require true ]
     * @support  float $ori_money 原金额 [Original type unsignedDouble] 
     * @support  float $pay_money 收金额 [Original type unsignedDouble] 
     * @support  int $create_by 创建人 [Original type uint] 
     * @support  string $stop_usage 结束使用时间 [ require true ]
     * @support  int $template_id 模板id [Original type uint] [ require true ]
     * @support  string $buy_channel 购买渠道 [ require true ]
     * @support  string $start_usage 开始使用时间 [ require true ]
     * @support  int $sale_store_id 门店id [Original type uint] 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function generateBatchCoupons () {
        return self::getClass()->generateBatchCoupons();
    }

    /**
     * 批量生成优惠券
     *
     * @support  int $count 创建数量 [Original type uint] [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  string $status 状态 [ require true ]
     * @support  int $channel 渠道号 [Original type uint] 
     * @support  int $userId 用户ID [Original type uint] 
     * @support  float $discount 折扣 [Original type double] [ require true ]
     * @support  float $oriMoney 原金额 [Original type unsignedDouble] 
     * @support  float $payMoney 收金额 [Original type unsignedDouble] 
     * @support  int $createBy 创建人 [Original type uint] 
     * @support  array $logUnique 记录唯一 
     * @support  string $stopUsage 结束使用时间 [ require true ]
     * @support  int $templateId 模板id [Original type uint] [ require true ]
     * @support  string $buyChannel 购买渠道 [ require true ]
     * @support  string $startUsage 开始使用时间 [ require true ]
     * @support  int $saleStoreId 门店id [Original type uint] 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function bulkGenerateCoupons () {
        return self::getClass()->bulkGenerateCoupons();
    }

    /**
     * 活动页生成优惠券
     * @deprecated
     *
     * @support  string $title 标题 
     * @support  string $status 状态 [ require true ]
     * @support  int $user_id 用户id 
     * @param  int $channel 渠道号 [Original type uint] [ require true ]
     * @support  float $discount 折扣 [Original type double] [ require true ]
     * @support  float $ori_money 原金额 [Original type unsignedDouble] 
     * @support  float $pay_money 支付金额 [Original type unsignedDouble] 
     * @support  string $stop_usage 结束使用时间 [ require true ]
     * @support  string $start_usage 开始使用时间 [ require true ]
     * @param  int $template_id 模板id [Original type uint] [ require true ]
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  string
     */
    public static function generateActivityCoupon (int $channel, int $template_id) {
        return self::getClass()->generateActivityCoupon([
            "channel" => $channel,
            "template_id" => $template_id,
        ]);
    }

    /**
     * 批量生成券【多用户绑定】
     *
     * @support  array $phones 手机号 
     * @support  array $user_ids 用户ids 
     * @support  string $title 标题 
     * @support  string $status 状态 [ require true ]
     * @support  float $discount 折扣 [Original type double] [ require true ]
     * @support  int $create_by 创建人 [Original type uint] 
     * @support  float $ori_money 原金额 [Original type unsignedDouble] 
     * @support  float $pay_money 支付金额 [Original type unsignedDouble] 
     * @support  string $stop_usage 结束使用时间 [ require true ]
     * @support  string $start_usage 开始使用时间 [ require true ]
     * @support  int $template_id 模板id [Original type uint] [ require true ]
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function bulkGenerateActivityCoupon () {
        return self::getClass()->bulkGenerateActivityCoupon();
    }

    /**
     * 生成会员券
     * @deprecated
     *
     * @support  int $count 生成数量 [Original type uint] [ require true ]
     * @support  float $discount 折扣 [Original type double] 
     * @support  int $user_id 用户id [Original type uint] [ require true ]
     * @support  int $template_id 模板ID [Original type uint] [ require true ]
     * @support  string $member_type 会员体系券类型 [ require true ]
     * @support  string $stop_usage 结束使用时间 [ require true ]
     * @support  string $start_usage 开始使用时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function generateMemberCoupons () {
        return self::getClass()->generateMemberCoupons();
    }

    /**
     * 获取列表
     *
     * @support  array $ids 卡ids 
     * @support  string $type 优惠券类型 
     * @support  array $codes 优惠码组 
     * @support  string $status 状态 
     * @support  int $user_id 用户id [Original type uint] 
     * @support  int $channel 渠道号 [Original type uint] 
     * @support  string $apply_in 应用于 
     * @support  string $used_at_end 使用时间止 
     * @support  array $multi_status 多状态查询 
     * @support  string $used_at_start 使用时间起 
     * @support  int $create_log_id 创建记录id [Original type uint] 
     * @support  array $order_ids 外部订单ids 
     * @support  array $order_diff_ids 外部订单diff-ids 
     * @support  string $created_at_end 创建时间止 
     * @support  string $created_at_start 创建时间起 
     * @support  bool $with_template_info 包含模板息 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取列表-分页
     *
     * @support  array $ids 卡ids 
     * @support  array $codes 优惠码组 
     * @support  string $status 状态 
     * @support  int $user_id 用户id [Original type uint] 
     * @support  string $apply_in 应用于 
     * @support  string $used_at_end 使用时间止 
     * @support  array $multi_status 多状态查询 
     * @support  int $create_log_id 创建记录id [Original type uint] 
     * @support  string $used_at_start 使用时间起 
     * @support  string $created_at_end 创建时间止 
     * @support  string $created_at_start 创建时间起 
     * @support  bool $with_template_info 包含类型信息 
     * @support  int $product_group_id 产品组ID [Original type uint] 
     * @support  int $product_id 产品ID [Original type uint] 
     * @support  int $store_dimension_id 适用门店维度id [Original type uint] 
     * @support  bool $action_scope 是否可以用于升级服务 
     * @support  string $description 描述 
     * @support  string $sort_field 排序字段 
     * @support  string $sort_direction 排序方向 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCoupons (int $page, int $page_size) {
        return self::getClass()->getCoupons([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取详情
     *
     * @support  int $id 优惠券id [Original type uint] 
     * @support  string $code 优惠code 
     * @throws  \Exception
     * @return  array
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * 优惠券延期
     *
     * @support  array $codes 优惠码 [Original type array&lt;string&gt;] 
     * @support  string $stop_usage 到期日期 [ require true ]
     * @support  int $operator 操作人 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delay () {
        return self::getClass()->delay();
    }

    /**
     * 更新适用订单【转门店】
     *
     * @param  int $couponId 优惠券id [Original type uint] [ require true ]
     * @param  int $newOrderId 订单id [Original type uint] [ require true ]
     * @param  int $newOrderDiffId 新订单diff-id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateTransferInfo (int $couponId, int $newOrderId, int $newOrderDiffId = NULL) {
        return self::getClass()->updateTransferInfo([
            "couponId" => $couponId,
            "newOrderId" => $newOrderId,
            "newOrderDiffId" => $newOrderDiffId,
        ]);
    }

    /**
     * 获得用户优惠券
     *
     * @support  int $user_id 用户id [Original type uint] [ require true ]
     * @support  string $status 优惠券状态 
     * @support  string $apply_in 应用于 
     * @support  bool $with_template_info 获取模板信息 
     * @throws  \Exception
     * @return  array
     */
    public static function getUserCoupons () {
        return self::getClass()->getUserCoupons();
    }

    /**
     * 标记用户券是否可用
     *
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @param  array $products 产品信息 [ require true ]
     * @param  int $store_id 门店id [Original type uint] [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function markUserCoupons (int $user_id, array $products, int $store_id, string $apply_in) {
        return self::getClass()->markUserCoupons([
            "user_id" => $user_id,
            "products" => $products,
            "store_id" => $store_id,
            "apply_in" => $apply_in,
        ]);
    }

    /**
     * 使用优惠券
     *
     * @param  int $id 优惠券id [Original type uint] [ require true ]
     * @support  int $user_id 用户id [Original type uint] [ require true ]
     * @support  int $order_id 订单ID [Original type uint] [ require true ]
     * @support  int $order_diff_id 订单diff—id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function use (int $id) {
        return self::getClass()->use([
            "id" => $id,
        ]);
    }

    /**
     * 获得优惠券可折扣金额
     *
     * @param  int $coupon_id 优惠券id [Original type uint] [ require true ]
     * @param  array $node_info 节点详情 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponDiscountPrice (int $coupon_id, array $node_info) {
        return self::getClass()->getCouponDiscountPrice([
            "coupon_id" => $coupon_id,
            "node_info" => $node_info,
        ]);
    }

    /**
     * 加修加印券和加印券可折扣金额
     *
     * @param  int $couponId 优惠券ID [Original type uint] [ require true ]
     * @param  float $perPrice 商品单价 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  float
     */
    public static function getSpecialCouponDiscount (int $couponId, float $perPrice) {
        return self::getClass()->getSpecialCouponDiscount([
            "couponId" => $couponId,
            "perPrice" => $perPrice,
        ]);
    }

    /**
     * 绑定优惠券
     *
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @param  string $code 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bind (int $user_id, string $code) {
        return self::getClass()->bind([
            "user_id" => $user_id,
            "code" => $code,
        ]);
    }

    /**
     * 退款返回优惠券
     *
     * @param  int $coupon_id 优惠券id [Original type uint] [ require true ]
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refund (int $coupon_id, int $user_id) {
        return self::getClass()->refund([
            "coupon_id" => $coupon_id,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 作废优惠券
     *
     * @param  array $codes 优惠码组 [Original type array&lt;string&gt;] [ require true ]
     * @support  string $type 作废类型 [ require true ]
     * @support  int $operator 操作人 [Original type uint] 
     * @support  array $extend 扩展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function abolishCoupons (array $codes) {
        return self::getClass()->abolishCoupons([
            "codes" => $codes,
        ]);
    }

    /**
     * 渠道统计
     *
     * @param  int $channel 渠道号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function statisticCoupons (int $channel) {
        return self::getClass()->statisticCoupons([
            "channel" => $channel,
        ]);
    }

    /**
     * 创建记录统计
     *
     * @param  array $logIds 渠道号 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function statisticCouponsByLogIds (array $logIds) {
        return self::getClass()->statisticCouponsByLogIds([
            "logIds" => $logIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Coupon\Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Coupon\Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}