<?php
namespace Mainto\Bridge\Enums\Preferential;

class OrderPayTypeEnum {
    const POS = 'pos';
    const CASH = 'cash';
    const WECHAT = 'wechat';
    const NO_PAY = 'no_pay';
    const ALIPAY = 'alipay';
    const ENTERPRISE = 'enterprise';
    const ICBC_WECHAT = 'icbc_wechat';
    const OFFLINE_ALIPAY = 'offline_alipay';
    const OFFLINE_WECHAT = 'offline_wechat';
    const PAYMAX_WECHAT = 'paymax_wechat';
    const PAYMAX_ALIPAY = 'paymax_alipay';
    const PAYMAX_WX_APP = 'paymax_wx_app';
    const OFFLINE_PAYMAX_ALIPAY = 'offline_paymax_alipay';
    const OFFLINE_PAYMAX_WECHAT = 'offline_paymax_wechat';
    const OFFLINE_PAYMAX_BANKCARD = 'offline_paymax_bankcard';
    /**
     * 全部支付类型
     */
    const ALL_PAY_TYPE = [0 => 'cash',1 => 'pos',2 => 'wechat',3 => 'alipay',4 => 'enterprise',5 => 'icbc_wechat',6 => 'offline_alipay',7 => 'offline_wechat',8 => 'paymax_wechat',9 => 'paymax_alipay',10 => 'paymax_wx_app',11 => 'offline_paymax_alipay',12 => 'offline_paymax_wechat',13 => 'offline_paymax_bankcard'];
    /**
     * 线上支付枚举值
     */
    const ONLINE_PAY_MAP = [0 => 'wechat',1 => 'alipay',2 => 'icbc_wechat',3 => 'paymax_wechat',4 => 'paymax_alipay',5 => 'paymax_wx_app'];
    /**
     * 线下支付枚举值
     */
    const OFFLINE_PAY_MAP = [0 => 'pos',1 => 'cash',2 => 'enterprise',3 => 'offline_alipay',4 => 'offline_wechat',5 => 'offline_paymax_alipay',6 => 'offline_paymax_wechat',7 => 'offline_paymax_bankcard'];
}