<?php
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getListByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByPageByParams(array $params)
 */
class GiftCardCover {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @support  string $title 卡面标题 require false
     * @support  string $img_path 卡面图片地址 [ require true ]
     * @support  uint $sequence 排序值 require false
     * @support  uint $topic_id 主题id require false
     * @support  bool $is_on_sale 是否在售 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新
     *
     * @param  uint $id id [ require true ]
     * @support  string $title 卡面标题 require false
     * @support  string $img_path 卡面图片地址 require false
     * @support  uint $sequence 排序值 require false
     * @support  uint $topic_id 主题id require false
     * @support  bool $is_on_sale 是否在售 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 获取列表
     *
     * @support  array $topic_ids 主题ids require false
     * @support  array $cover_ids 卡面ids require false
     * @support  string $title 卡面标题 require false
     * @support  bool $has_topic_info 是否包含主题信息 require false
     * @support  bool $is_on_sale 是否在售 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 获取详情
     *
     * @param  uint $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (int $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * 获取列表-分页
     *
     * @support  array $topic_ids 主题ids require false
     * @support  string $title 卡面标题 require false
     * @support  bool $has_topic_info 是否包含主题信息 require false
     * @support  bool $is_on_sale 是否在售 require false
     * @param  uint $page 页码 [ require true ]
     * @param  uint $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListByPage (int $page = 1, int $page_size = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'GiftCard\GiftCardCover');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'GiftCard\GiftCardCover');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}