<?php
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method generateBatchCardsByParams(array $params)
 * @method bulkGenerateCardsByParams(array $params)
 * @method generateActivityCardByParams(array $params)
 * @method bulkGenerateActivityCardByParams(array $params)
 * @method listByParams(array $params)
 * @method getCardsByParams(array $params)
 * @method infoByParams(array $params)
 * @method delayByParams(array $params)
 * @method updateTransferInfoByParams(array $params)
 * @method getUserCardsByParams(array $params)
 * @method markUserCardsByParams(array $params)
 * @method getCardDiscountPriceByParams(array $params)
 * @method useByParams(array $params)
 * @method bindByParams(array $params)
 * @method refundByParams(array $params)
 * @method abolishCardsByParams(array $params)
 * @method returnByParams(array $params)
 * @method statisticCardsByParams(array $params)
 * @method replaceByParams(array $params)
 */
class ProductCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品卡生成【实体卡】
     *
     * @support  int $count 创建数量 [Original type uint] [ require true ]
     * @support  array $extend 拓展信息[title] 
     * @support  int $template_id 模板id [Original type uint] [ require true ]
     * @support  int $create_by 创建人 [Original type uint] [ require true ]
     * @support  string $stop_usage 结束使用时间 
     * @support  string $start_usage 开始使用时间 
     * @support  int $validity_period 有效期 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function generateBatchCards () {
        return self::getClass()->generateBatchCards();
    }

    /**
     * 批量生成优惠券
     *
     * @support  int $count 生成数量 [Original type uint] 
     * @support  string $status 状态 [ require true ]
     * @support  int $userId 用户id 
     * @support  int $channel 渠道号 [Original type uint] 
     * @support  string $stopUsage 结束使用时间 [ require true ]
     * @support  string $startUsage 开始使用时间 [ require true ]
     * @param  int $templateId 模板id [Original type uint] [ require true ]
     * @support  array $extend 拓展信息 
     * @support  array $logUniqueByFields 根据字段保持记录唯一 
     * @throws  \Exception
     * @return  mixed
     */
    public static function bulkGenerateCards (int $templateId) {
        return self::getClass()->bulkGenerateCards([
            "templateId" => $templateId,
        ]);
    }

    /**
     * 活动页生成优惠券
     * @deprecated
     *
     * @support  int $count 生成数量 [Original type uint] 
     * @support  string $status 状态 [ require true ]
     * @support  int $user_id 用户id 
     * @param  int $channel 渠道号 [Original type uint] [ require true ]
     * @support  string $stop_usage 结束使用时间 [ require true ]
     * @support  string $start_usage 开始使用时间 [ require true ]
     * @param  int $template_id 模板id [Original type uint] [ require true ]
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  array
     */
    public static function generateActivityCard (int $template_id, int $channel) {
        return self::getClass()->generateActivityCard([
            "template_id" => $template_id,
            "channel" => $channel,
        ]);
    }

    /**
     * 批量送卡
     *
     * @support  array $phones 手机号 
     * @support  array $user_ids 用户ids 
     * @support  string $status 状态 [ require true ]
     * @support  int $create_by 创建人 [Original type uint] [ require true ]
     * @support  string $stop_usage 结束使用时间 [ require true ]
     * @support  string $start_usage 开始使用时间 [ require true ]
     * @support  int $template_id 模板id [Original type uint] [ require true ]
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  array
     */
    public static function bulkGenerateActivityCard () {
        return self::getClass()->bulkGenerateActivityCard();
    }

    /**
     * 获取列表
     *
     * @support  array $ids 卡ids 
     * @support  array $codes 优惠码 
     * @support  string $status 状态 
     * @support  int $user_id 用户ID [Original type uint] 
     * @support  string $apply_in 应用于 
     * @support  array $order_ids 订单IDs [Original type array&lt;int&gt;] 
     * @support  string $used_at_end 使用时间止 
     * @support  array $multi_status 状态组 
     * @support  int $create_log_id 记录id [Original type uint] 
     * @support  string $used_at_start 使用时间起 
     * @support  string $created_at_end 创建时间止 
     * @support  string $created_at_start 创建时间起 
     * @support  bool $with_template_info 包含模板信息 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取列表-分页
     *
     * @support  array $ids 卡ids 
     * @support  array $codes 优惠码组 
     * @support  int $user_id 用户ID [Original type uint] 
     * @support  array $order_ids 订单IDs [Original type array&lt;int&gt;] 
     * @support  string $apply_in 应用于 
     * @support  array $sort_scope 排序作用域 
     * @support  array $multi_status 状态 
     * @support  string $used_at_end 使用时间止 
     * @support  string $used_at_start 使用时间起 
     * @support  int $create_log_id 记录id [Original type uint] 
     * @support  string $created_at_end 创建时间止 
     * @support  string $created_at_start 创建时间起 
     * @support  bool $with_template_info 包含模板信息 
     * @support  int $product_group_id 产品组ID [Original type uint] 
     * @support  int $product_id 产品ID [Original type uint] 
     * @support  int $service_product_id 服务ID [Original type uint] 
     * @support  int $store_dimension_id 适用门店维度ID [Original type uint] 
     * @support  string $description 描述 
     * @support  string $sort_field 排序字段 
     * @support  string $sort_direction 排序方向 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCards (int $page, int $page_size) {
        return self::getClass()->getCards([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 详情
     *
     * @support  int $id 卡id 
     * @support  string $code 优惠码 
     * @throws  \Exception
     * @return  array
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * 产品卡延期
     *
     * @support  array $codes 优惠码 [ require true ]
     * @support  string $stop_usage 到期日期 [ require true ]
     * @support  int $operator 操作人-参数作废，计入extend [Original type uint] 
     * @support  array $extend 扩展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function delay () {
        return self::getClass()->delay();
    }

    /**
     * 更新适用订单【转门店】
     *
     * @param  int $id 优惠券id [Original type uint] [ require true ]
     * @param  int $newOrderId 订单diff-id [Original type uint] [ require true ]
     * @param  int $newOrderDiffId 新订单diff-id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateTransferInfo (int $id, int $newOrderId, int $newOrderDiffId = NULL) {
        return self::getClass()->updateTransferInfo([
            "id" => $id,
            "newOrderId" => $newOrderId,
            "newOrderDiffId" => $newOrderDiffId,
        ]);
    }

    /**
     * 获得用户产品卡
     *
     * @support  int $user_id 用户id [Original type uint] [ require true ]
     * @support  string $status 状态 
     * @support  string $apply_in 应用于 
     * @support  bool $with_template_info 获取模板信息 
     * @throws  \Exception
     * @return  array
     */
    public static function getUserCards () {
        return self::getClass()->getUserCards();
    }

    /**
     * 标记用户券是否可用
     *
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @param  array $products 产品信息 [ require true ]
     * @param  int $store_id 门店id [Original type uint] [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function markUserCards (int $user_id, array $products, int $store_id, string $apply_in) {
        return self::getClass()->markUserCards([
            "user_id" => $user_id,
            "products" => $products,
            "store_id" => $store_id,
            "apply_in" => $apply_in,
        ]);
    }

    /**
     * 获得优惠券可折扣金额
     *
     * @param  int $card_id 产品卡id [Original type uint] [ require true ]
     * @param  array $node_info 产品详情 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCardDiscountPrice (int $card_id, array $node_info) {
        return self::getClass()->getCardDiscountPrice([
            "card_id" => $card_id,
            "node_info" => $node_info,
        ]);
    }

    /**
     * 使用产品卡
     *
     * @param  int $id 产品卡id [Original type uint] [ require true ]
     * @support  int $user_id 用户id [Original type uint] [ require true ]
     * @support  int $order_id 订单ID [Original type uint] [ require true ]
     * @support  int $order_diff_id 订单diff—id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function use (int $id) {
        return self::getClass()->use([
            "id" => $id,
        ]);
    }

    /**
     * 产品卡绑定
     *
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @param  string $code 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bind (int $user_id, string $code) {
        return self::getClass()->bind([
            "user_id" => $user_id,
            "code" => $code,
        ]);
    }

    /**
     * 退款返回产品卡
     *
     * @param  int $id 产品卡id [Original type uint] [ require true ]
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refund (int $id, int $user_id) {
        return self::getClass()->refund([
            "id" => $id,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 作废产品卡
     *
     * @param  array $codes 优惠码组 [Original type array&lt;string&gt;] [ require true ]
     * @support  int $operator 操作人-参数作废，计入extend [Original type uint] 
     * @support  array $extend 扩展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function abolishCards (array $codes) {
        return self::getClass()->abolishCards([
            "codes" => $codes,
        ]);
    }

    /**
     * 用户退回产品券【返回赠送券-生日照】
     *
     * @param  string $code 优惠码 [ require true ]
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function return (string $code, int $user_id) {
        return self::getClass()->return([
            "code" => $code,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 渠道统计
     *
     * @param  int $channel 渠道号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function statisticCards (int $channel) {
        return self::getClass()->statisticCards([
            "channel" => $channel,
        ]);
    }

    /**
     * 产品券替换
     *
     * @param  string $type 替换类型 [ require true ]
     * @param  int $cardId 替换券码ID [Original type uint] [ require true ]
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @param  int $templateId 模板ID [Original type uint] [ require true ]
     * @param  bool $abolishOriginal 是否作废原券码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function replace (int $cardId, string $type, int $userId, int $templateId, bool $abolishOriginal) {
        return self::getClass()->replace([
            "cardId" => $cardId,
            "type" => $type,
            "userId" => $userId,
            "templateId" => $templateId,
            "abolishOriginal" => $abolishOriginal,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Coupon\ProductCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Coupon\ProductCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}