<?php
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method prePayByParams(array $params)
 * @method cancelPrePayByParams(array $params)
 * @method submitPrePayByParams(array $params)
 * @method getPayDetailByPaymentNoByParams(array $params)
 * @method getPayDetailByOrderNoByParams(array $params)
 * @method getPaymentInfoByOrderNoByParams(array $params)
 * @method getPaymentInfoByOrderIdByParams(array $params)
 * @method refundByParams(array $params)
 * @method getCanRefundMoneyByParams(array $params)
 * @method updateTransferInfoByParams(array $params)
 * @method getPaymentItemsWithRefundIdByParams(array $params)
 */
class GiftCardPayment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预支付
     *
     * @param  float $money 金额 [Original type double] [ require true ]
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @param  int $outOrderId 外部关联订单ID [Original type uint] [ require true ]
     * @param  string $outOrderNo 外部关联订单号 [ require true ]
     * @param  string $source 支付来源 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function prePay (int $outOrderId, float $money, int $userId, string $source, string $outOrderNo) {
        return self::getClass()->prePay([
            "outOrderId" => $outOrderId,
            "money" => $money,
            "userId" => $userId,
            "source" => $source,
            "outOrderNo" => $outOrderNo,
        ]);
    }

    /**
     * 撤销预支付
     *
     * @param  string $payment_no 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelPrePay (string $payment_no) {
        return self::getClass()->cancelPrePay([
            "payment_no" => $payment_no,
        ]);
    }

    /**
     * 确认预支付
     *
     * @param  string $payment_no 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitPrePay (string $payment_no) {
        return self::getClass()->submitPrePay([
            "payment_no" => $payment_no,
        ]);
    }

    /**
     * 根据支付流水号获取支付详情
     *
     * @param  string $payment_no 支付流水号 [ require true ]
     * @param  bool $with_payment_items 支付详情 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPayDetailByPaymentNo (string $payment_no, bool $with_payment_items) {
        return self::getClass()->getPayDetailByPaymentNo([
            "payment_no" => $payment_no,
            "with_payment_items" => $with_payment_items,
        ]);
    }

    /**
     * 根据订单号获取支付详情-作废
     * @deprecated
     *
     * @param  string $order_no 外部业务订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPayDetailByOrderNo (string $order_no) {
        return self::getClass()->getPayDetailByOrderNo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 根据订单号获取支付详情
     *
     * @param  string $orderNo 外部业务订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPaymentInfoByOrderNo (string $orderNo) {
        return self::getClass()->getPaymentInfoByOrderNo([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 根据订单外部关联ID获取支付详情
     *
     * @param  int $outOrderId 订单diff-id [Original type uint] [ require true ]
     * @param  string $source 订单来源 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPaymentInfoByOrderId (int $outOrderId, string $source) {
        return self::getClass()->getPaymentInfoByOrderId([
            "outOrderId" => $outOrderId,
            "source" => $source,
        ]);
    }

    /**
     * 订单退款【礼品卡支付订单】
     *
     * @param  float $money 退款金额 [Original type double] [ require true ]
     * @param  string $payment_no 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refund (float $money, string $payment_no) {
        return self::getClass()->refund([
            "money" => $money,
            "payment_no" => $payment_no,
        ]);
    }

    /**
     * 获取可退款礼品卡金额
     *
     * @param  string $payment_no 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCanRefundMoney (string $payment_no) {
        return self::getClass()->getCanRefundMoney([
            "payment_no" => $payment_no,
        ]);
    }

    /**
     * 更新适用订单【转门店】
     *
     * @param  string $paymentNo 礼品卡支付流水号 [ require true ]
     * @param  int $outOrderId 外部关联订单ID [Original type uint] [ require true ]
     * @param  string $outOrderNo 外部关联订单号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function updateTransferInfo (string $paymentNo, int $outOrderId, string $outOrderNo) {
        return self::getClass()->updateTransferInfo([
            "paymentNo" => $paymentNo,
            "outOrderId" => $outOrderId,
            "outOrderNo" => $outOrderNo,
        ]);
    }

    /**
     * 获取支付详情【包含是否礼品卡退款id】
     *
     * @param  string $payment_no 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPaymentItemsWithRefundId (string $payment_no) {
        return self::getClass()->getPaymentItemsWithRefundId([
            "payment_no" => $payment_no,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'GiftCard\GiftCardPayment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'GiftCard\GiftCardPayment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}